/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.client.common;

import com.cloudera.livy.annotations.Private;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Private
public abstract class ClientConf<T extends ClientConf>
implements Iterable<Map.Entry<String, String>> {
    private static final Map<String, TimeUnit> TIME_SUFFIXES;
    public static final boolean TEST_MODE;
    protected final ConcurrentMap<String, String> config = new ConcurrentHashMap<String, String>();

    protected ClientConf(Properties config) {
        if (config != null) {
            for (String key : config.stringPropertyNames()) {
                this.config.put(key, config.getProperty(key));
            }
        }
    }

    public String get(String key) {
        return (String)this.config.get(key);
    }

    public T set(String key, String value) {
        this.config.put(key, value);
        return (T)this;
    }

    public T setIfMissing(String key, String value) {
        this.config.putIfAbsent(key, value);
        return (T)this;
    }

    public T setAll(ClientConf<?> other) {
        for (Map.Entry<String, String> e : other) {
            this.set(e.getKey(), e.getValue());
        }
        return (T)this;
    }

    public String get(ConfEntry e) {
        String value = this.get(e, String.class);
        return (String)(value != null ? value : e.dflt());
    }

    public boolean getBoolean(ConfEntry e) {
        String val = this.get(e, Boolean.class);
        if (val != null) {
            return Boolean.parseBoolean(val);
        }
        return (Boolean)e.dflt();
    }

    public int getInt(ConfEntry e) {
        String val = this.get(e, Integer.class);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return (Integer)e.dflt();
    }

    public long getLong(ConfEntry e) {
        String val = this.get(e, Long.class);
        if (val != null) {
            return Long.parseLong(val);
        }
        return (Long)e.dflt();
    }

    public long getTimeAsMs(ConfEntry e) {
        Matcher m;
        String time = this.get(e, String.class);
        if (time == null) {
            this.check(e.dflt() != null, "ConfEntry %s doesn't have a default value, cannot convert to time value.", e.key());
            time = (String)e.dflt();
        }
        if (!(m = Pattern.compile("(-?[0-9]+)([a-z]+)?").matcher(time.toLowerCase())).matches()) {
            throw new IllegalArgumentException("Invalid time string: " + time);
        }
        long val = Long.parseLong(m.group(1));
        String suffix = m.group(2);
        if (suffix != null && !TIME_SUFFIXES.containsKey(suffix)) {
            throw new IllegalArgumentException("Invalid suffix: \"" + suffix + "\"");
        }
        return TimeUnit.MILLISECONDS.convert(val, suffix != null ? TIME_SUFFIXES.get(suffix) : TimeUnit.MILLISECONDS);
    }

    public T set(ConfEntry e, Object value) {
        this.check(this.typesMatch(value, e.dflt()), "Value doesn't match configuration entry type for %s.", e.key());
        if (value == null) {
            this.config.remove(e.key());
        } else {
            this.config.put(e.key(), value.toString());
        }
        return (T)this;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.config.entrySet().iterator();
    }

    private String get(ConfEntry e, Class<?> requestedType) {
        this.check(this.getType(e.dflt()).equals(requestedType), "Invalid type conversion requested for %s.", e.key());
        return (String)this.config.get(e.key());
    }

    private boolean typesMatch(Object test, Object expected) {
        return test == null || this.getType(test).equals(this.getType(expected));
    }

    private Class<?> getType(Object o) {
        return o != null ? o.getClass() : String.class;
    }

    private void check(boolean test, String message, Object ... args) {
        if (!test) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    static {
        TEST_MODE = Boolean.parseBoolean(System.getenv("LIVY_TEST"));
        TIME_SUFFIXES = new HashMap<String, TimeUnit>();
        TIME_SUFFIXES.put("us", TimeUnit.MICROSECONDS);
        TIME_SUFFIXES.put("ms", TimeUnit.MILLISECONDS);
        TIME_SUFFIXES.put("s", TimeUnit.SECONDS);
        TIME_SUFFIXES.put("m", TimeUnit.MINUTES);
        TIME_SUFFIXES.put("min", TimeUnit.MINUTES);
        TIME_SUFFIXES.put("h", TimeUnit.HOURS);
        TIME_SUFFIXES.put("d", TimeUnit.DAYS);
    }

    public static interface ConfEntry {
        public String key();

        public Object dflt();
    }
}

