/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.jgit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.ReadableInstant;
import pl.project13.jgit.DescribeResult;
import pl.project13.jgit.dummy.DatedRevTag;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.log.StdOutLoggerBridge;
import pl.project13.maven.git.util.Pair;

public class DescribeCommand
extends GitCommand<DescribeResult> {
    private LoggerBridge loggerBridge;
    private Optional<String> matchOption = Optional.absent();
    private int abbrev = 7;
    private boolean tagsFlag = false;
    private boolean alwaysFlag = true;
    private boolean forceLongFormat = false;
    private Optional<String> dirtyOption = Optional.absent();

    @NotNull
    public static DescribeCommand on(Repository repo) {
        return new DescribeCommand(repo);
    }

    private DescribeCommand(Repository repo) {
        this(repo, true);
    }

    private DescribeCommand(Repository repo, boolean verbose) {
        super(repo);
        this.initDefaultLoggerBridge(verbose);
        this.setVerbose(verbose);
    }

    private void initDefaultLoggerBridge(boolean verbose) {
        this.loggerBridge = new StdOutLoggerBridge(verbose);
    }

    @NotNull
    public DescribeCommand setVerbose(boolean verbose) {
        this.loggerBridge.setVerbose(verbose);
        return this;
    }

    @NotNull
    public DescribeCommand withLoggerBridge(LoggerBridge bridge) {
        this.loggerBridge = bridge;
        return this;
    }

    @NotNull
    public DescribeCommand always(boolean always) {
        this.alwaysFlag = always;
        this.log("--always =", always);
        return this;
    }

    @NotNull
    public DescribeCommand forceLongFormat(@Nullable Boolean forceLongFormat) {
        if (forceLongFormat != null) {
            this.forceLongFormat = forceLongFormat;
            this.log("--long = %s", forceLongFormat);
        }
        return this;
    }

    @NotNull
    public DescribeCommand abbrev(@Nullable Integer n) {
        if (n != null) {
            Preconditions.checkArgument((n < 41 ? 1 : 0) != 0, (Object)String.format("N (commit abbres length) must be < 41. (Was:[%s])", n));
            Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)String.format("N (commit abbrev length) must be positive! (Was [%s])", n));
            this.log("--abbrev =", n);
            this.abbrev = n;
        }
        return this;
    }

    @NotNull
    public DescribeCommand tags(@Nullable Boolean includeLightweightTagsInSearch) {
        if (includeLightweightTagsInSearch != null) {
            this.tagsFlag = includeLightweightTagsInSearch;
            this.log("--tags =", includeLightweightTagsInSearch);
        }
        return this;
    }

    public DescribeCommand tags() {
        return this.tags(true);
    }

    @NotNull
    public DescribeCommand apply(@Nullable GitDescribeConfig config) {
        if (config != null) {
            this.always(config.isAlways());
            this.dirty(config.getDirty());
            this.abbrev(config.getAbbrev());
            this.forceLongFormat(config.getForceLongFormat());
            this.tags(config.getTags());
            this.match(config.getMatch());
        }
        return this;
    }

    @NotNull
    public DescribeCommand dirty(@Nullable String dirtyMarker) {
        Optional option = Optional.fromNullable((Object)dirtyMarker);
        this.log("--dirty =", option.or((Object)""));
        this.dirtyOption = option;
        return this;
    }

    @NotNull
    public DescribeCommand match(@Nullable String pattern) {
        this.matchOption = Optional.fromNullable((Object)pattern);
        this.log("--match =", this.matchOption.or((Object)""));
        return this;
    }

    public DescribeResult call() throws GitAPIException {
        ObjectReader objectReader = this.repo.newObjectReader();
        Map<ObjectId, List<String>> tagObjectIdToName = this.findTagObjectIds(this.repo, this.tagsFlag);
        RevCommit headCommit = this.findHeadObjectId(this.repo);
        ObjectId headCommitId = headCommit.getId();
        boolean dirty = this.findDirtyState(this.repo);
        if (DescribeCommand.hasTags((ObjectId)headCommit, tagObjectIdToName)) {
            String tagName = tagObjectIdToName.get(headCommit).iterator().next();
            this.log("The commit we're on is a Tag ([", tagName, "]), returning.");
            return new DescribeResult(tagName, dirty, this.dirtyOption);
        }
        List<RevCommit> commits = this.findCommitsUntilSomeTag(this.repo, headCommit, tagObjectIdToName);
        if (DescribeCommand.foundZeroTags(tagObjectIdToName) || commits.isEmpty()) {
            return new DescribeResult(objectReader, headCommitId, dirty, this.dirtyOption).withCommitIdAbbrev(this.abbrev);
        }
        int distance = this.distanceBetween(this.repo, headCommit, commits.get(0));
        String tagName = tagObjectIdToName.get(commits.get(0)).iterator().next();
        Pair<Integer, String> howFarFromWhichTag = Pair.of(distance, tagName);
        return this.createDescribeResult(objectReader, headCommitId, dirty, howFarFromWhichTag);
    }

    private DescribeResult createDescribeResult(ObjectReader objectReader, ObjectId headCommitId, boolean dirty, @Nullable Pair<Integer, String> howFarFromWhichTag) {
        if (howFarFromWhichTag == null) {
            return new DescribeResult(objectReader, headCommitId, dirty, this.dirtyOption).withCommitIdAbbrev(this.abbrev);
        }
        if ((Integer)howFarFromWhichTag.first > 0 || this.forceLongFormat) {
            return new DescribeResult(objectReader, (String)howFarFromWhichTag.second, (int)((Integer)howFarFromWhichTag.first), headCommitId, dirty, this.dirtyOption).withCommitIdAbbrev(this.abbrev);
        }
        if ((Integer)howFarFromWhichTag.first == 0) {
            return new DescribeResult((String)howFarFromWhichTag.second).withCommitIdAbbrev(this.abbrev);
        }
        if (this.alwaysFlag) {
            return new DescribeResult(objectReader, headCommitId).withCommitIdAbbrev(this.abbrev);
        }
        return DescribeResult.EMPTY;
    }

    private static boolean foundZeroTags(@NotNull Map<ObjectId, List<String>> tags) {
        return tags.isEmpty();
    }

    @VisibleForTesting
    boolean findDirtyState(Repository repo) throws GitAPIException {
        Git git = Git.wrap((Repository)repo);
        Status status = git.status().call();
        boolean isDirty = !status.getAdded().isEmpty() || !status.getChanged().isEmpty() || !status.getRemoved().isEmpty() || !status.getMissing().isEmpty() || !status.getModified().isEmpty() || !status.getConflicting().isEmpty();
        this.log("Repo is in dirty state [", isDirty, "]");
        return isDirty;
    }

    @VisibleForTesting
    static boolean hasTags(ObjectId headCommit, @NotNull Map<ObjectId, List<String>> tagObjectIdToName) {
        return tagObjectIdToName.containsKey(headCommit);
    }

    RevCommit findHeadObjectId(@NotNull Repository repo) throws RuntimeException {
        try {
            ObjectId headId = repo.resolve("HEAD");
            RevWalk walk = new RevWalk(repo);
            RevCommit headCommit = walk.lookupCommit((AnyObjectId)headId);
            walk.dispose();
            this.log("HEAD is [", headCommit.getName(), "] ");
            return headCommit;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to obtain HEAD commit!", ex);
        }
    }

    private List<RevCommit> findCommitsUntilSomeTag(Repository repo, RevCommit head, @NotNull Map<ObjectId, List<String>> tagObjectIdToName) {
        RevWalk revWalk = new RevWalk(repo);
        try {
            revWalk.markStart(head);
            for (RevCommit commit : revWalk) {
                List<String> maybeList;
                ObjectId objId = commit.getId();
                if (tagObjectIdToName.size() <= 0 || (maybeList = tagObjectIdToName.get(objId)) == null || maybeList.get(0) == null) continue;
                return Collections.singletonList(commit);
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find commits until some tag", e);
        }
    }

    private int distanceBetween(@NotNull Repository repo, @NotNull RevCommit child, @NotNull RevCommit parent) {
        RevWalk revWalk = new RevWalk(repo);
        try {
            revWalk.markStart(child);
            HashSet seena = Sets.newHashSet();
            HashSet seenb = Sets.newHashSet();
            LinkedList q = Lists.newLinkedList();
            q.add(revWalk.parseCommit((AnyObjectId)child));
            int distance = 0;
            ObjectId parentId = parent.getId();
            while (q.size() > 0) {
                RevCommit commit = (RevCommit)q.remove();
                ObjectId commitId = commit.getId();
                if (seena.contains(commitId)) continue;
                seena.add(commitId);
                if (parentId.equals((AnyObjectId)commitId)) {
                    DescribeCommand.seeAllParents(revWalk, commit, seenb);
                    for (ObjectId oid : seenb) {
                        if (!seena.contains(oid)) continue;
                        --distance;
                    }
                    seena.addAll(seenb);
                    continue;
                }
                for (RevCommit oid : commit.getParents()) {
                    if (seena.contains(oid)) continue;
                    q.add(revWalk.parseCommit((AnyObjectId)oid));
                }
                ++distance;
            }
            int n = distance;
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to calculate distance between [%s] and [%s]", child, parent), e);
        }
        finally {
            revWalk.dispose();
        }
    }

    private static void seeAllParents(@NotNull RevWalk revWalk, RevCommit child, @NotNull Set<ObjectId> seen) throws IOException {
        LinkedList q = Lists.newLinkedList();
        q.add(child);
        while (q.size() > 0) {
            RevCommit commit = (RevCommit)q.remove();
            for (RevCommit oid : commit.getParents()) {
                if (seen.contains(oid)) continue;
                seen.add((ObjectId)oid);
                q.add(revWalk.parseCommit((AnyObjectId)oid));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ObjectId, List<String>> findTagObjectIds(@NotNull Repository repo, boolean tagsFlag) {
        HashMap commitIdsToTags = Maps.newHashMap();
        RevWalk walk = new RevWalk(repo);
        try {
            walk.markStart(walk.parseCommit((AnyObjectId)repo.resolve("HEAD")));
            List tagRefs = Git.wrap((Repository)repo).tagList().call();
            String matchPattern = this.createMatchPattern();
            Pattern regex = Pattern.compile(matchPattern);
            this.log("Tag refs [", tagRefs, "]");
            for (Ref hashMap : tagRefs) {
                walk.reset();
                String name = hashMap.getName();
                if (!regex.matcher(name).matches()) {
                    this.log("Skipping tagRef with name [", name, "] as it doesn't match [", matchPattern, "]");
                    continue;
                }
                ObjectId resolvedCommitId = repo.resolve(name);
                try {
                    RevTag revTag = walk.parseTag((AnyObjectId)resolvedCommitId);
                    ObjectId taggedCommitId = revTag.getObject().getId();
                    this.log("Resolved tag [", revTag.getTagName(), "] [", revTag.getTaggerIdent(), "], points at [", taggedCommitId, "] ");
                    while (this.isTagId(taggedCommitId)) {
                        taggedCommitId = walk.parseTag((AnyObjectId)taggedCommitId).getObject().getId();
                    }
                    if (commitIdsToTags.containsKey(taggedCommitId)) {
                        ((List)commitIdsToTags.get(taggedCommitId)).add(new DatedRevTag(revTag));
                        continue;
                    }
                    commitIdsToTags.put(taggedCommitId, Lists.newArrayList((Object[])new DatedRevTag[]{new DatedRevTag(revTag)}));
                }
                catch (IncorrectObjectTypeException ex) {
                    if (!tagsFlag) continue;
                    this.log("Including lightweight tag [", name, "]");
                    DatedRevTag datedRevTag = new DatedRevTag((AnyObjectId)resolvedCommitId, name);
                    if (commitIdsToTags.containsKey(resolvedCommitId)) {
                        ((List)commitIdsToTags.get(resolvedCommitId)).add(datedRevTag);
                        continue;
                    }
                    commitIdsToTags.put(resolvedCommitId, Lists.newArrayList((Object[])new DatedRevTag[]{datedRevTag}));
                }
                catch (Exception ignored) {
                    this.error("Failed while parsing [", hashMap, "] -- ", Throwables.getStackTraceAsString((Throwable)ignored));
                }
            }
            for (Map.Entry entry : commitIdsToTags.entrySet()) {
                this.log("key [", entry.getKey(), "], tags => [", entry.getValue(), "] ");
            }
            HashMap<ObjectId, List<String>> commitIdsToTagNames = this.transformRevTagsMapToDateSortedTagNames(commitIdsToTags);
            this.log("Created map: [", commitIdsToTagNames, "] ");
            HashMap<ObjectId, List<String>> hashMap = commitIdsToTagNames;
            return hashMap;
        }
        catch (Exception e) {
            this.log("Unable to locate tags\n[", Throwables.getStackTraceAsString((Throwable)e), "]");
        }
        finally {
            walk.release();
        }
        return Collections.emptyMap();
    }

    private boolean isTagId(ObjectId objectId) {
        return objectId.toString().startsWith("tag ");
    }

    private HashMap<ObjectId, List<String>> transformRevTagsMapToDateSortedTagNames(Map<ObjectId, List<DatedRevTag>> commitIdsToTags) {
        HashMap commitIdsToTagNames = Maps.newHashMap();
        for (Map.Entry<ObjectId, List<DatedRevTag>> objectIdListEntry : commitIdsToTags.entrySet()) {
            List<DatedRevTag> tags = objectIdListEntry.getValue();
            ArrayList newTags = Lists.newArrayList(tags);
            Collections.sort(newTags, new Comparator<DatedRevTag>(){

                @Override
                public int compare(DatedRevTag revTag, DatedRevTag revTag2) {
                    return revTag2.date.compareTo((ReadableInstant)revTag.date);
                }
            });
            List tagNames = Lists.transform((List)newTags, (Function)new Function<DatedRevTag, String>(){

                public String apply(DatedRevTag input) {
                    return DescribeCommand.trimFullTagName(input.tagName);
                }
            });
            commitIdsToTagNames.put(objectIdListEntry.getKey(), tagNames);
        }
        return commitIdsToTagNames;
    }

    private String createMatchPattern() {
        if (!this.matchOption.isPresent()) {
            return ".*";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("^refs/tags/\\Q");
        buf.append(((String)this.matchOption.get()).replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q"));
        buf.append("\\E$");
        return buf.toString();
    }

    @VisibleForTesting
    static String trimFullTagName(@NotNull String tagName) {
        return tagName.replaceFirst("refs/tags/", "");
    }

    private void log(Object ... parts) {
        this.loggerBridge.log(parts);
    }

    private void error(Object ... parts) {
        this.loggerBridge.error(parts);
    }
}

