/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker.nio;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.TachyonByteBuffer;

public class DataServerMessage {
    public static final short DATA_SERVER_REQUEST_MESSAGE = 1;
    public static final short DATA_SERVER_RESPONSE_MESSAGE = 2;
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static final int HEADER_LENGTH = 26;
    private final boolean mToSendData;
    private final short mMessageType;
    private boolean mIsMessageReady;
    private ByteBuffer mHeader;
    private long mBlockId;
    private long mOffset;
    private long mLength;
    private int mLockId = -1;
    private TachyonByteBuffer mTachyonData = null;
    private ByteBuffer mData = null;

    public static DataServerMessage createBlockRequestMessage() {
        DataServerMessage ret = new DataServerMessage(false, 1);
        ret.mHeader = ByteBuffer.allocate(26);
        return ret;
    }

    public static DataServerMessage createBlockRequestMessage(long blockId) {
        return DataServerMessage.createBlockRequestMessage(blockId, 0L, -1L);
    }

    public static DataServerMessage createBlockRequestMessage(long blockId, long offset, long len) {
        DataServerMessage ret = new DataServerMessage(true, 1);
        ret.mHeader = ByteBuffer.allocate(26);
        ret.mBlockId = blockId;
        ret.mOffset = offset;
        ret.mLength = len;
        ret.generateHeader();
        ret.mData = ByteBuffer.allocate(0);
        ret.mIsMessageReady = true;
        return ret;
    }

    public static DataServerMessage createBlockResponseMessage(boolean toSend, long blockId, ByteBuffer data) {
        return DataServerMessage.createBlockResponseMessage(toSend, blockId, 0L, -1L, data);
    }

    public static DataServerMessage createBlockResponseMessage(boolean toSend, long blockId, long offset, long len, ByteBuffer data) {
        DataServerMessage ret = new DataServerMessage(toSend, 2);
        if (toSend) {
            if (data != null) {
                ret.mHeader = ByteBuffer.allocate(26);
                ret.mBlockId = blockId;
                ret.mOffset = offset;
                ret.mLength = len;
                ret.mTachyonData = null;
                ret.mData = data;
                ret.mIsMessageReady = true;
                ret.generateHeader();
            } else {
                ret.mBlockId = -blockId;
                ret.mLength = 0L;
                ret.mHeader = ByteBuffer.allocate(26);
                ret.mData = ByteBuffer.allocate(0);
                ret.mIsMessageReady = true;
                ret.generateHeader();
                LOG.error("The file is not here! blockId:{}", (Object)blockId);
            }
        } else {
            ret.mHeader = ByteBuffer.allocate(26);
            ret.mData = null;
        }
        return ret;
    }

    private DataServerMessage(boolean isToSendData, short msgType) {
        this.mToSendData = isToSendData;
        this.mMessageType = msgType;
        this.mIsMessageReady = false;
    }

    public void checkReady() {
        Preconditions.checkState((boolean)this.mIsMessageReady, (Object)"Message is not ready.");
    }

    public void close() {
        if (this.mMessageType == 2) {
            try {
                if (this.mTachyonData != null) {
                    this.mTachyonData.close();
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
        }
    }

    public boolean finishSending() {
        this.isSend(true);
        return this.mHeader.remaining() == 0 && this.mData.remaining() == 0;
    }

    private void generateHeader() {
        this.mHeader.clear();
        this.mHeader.putShort(this.mMessageType);
        this.mHeader.putLong(this.mBlockId);
        this.mHeader.putLong(this.mOffset);
        this.mHeader.putLong(this.mLength);
        this.mHeader.flip();
    }

    public long getBlockId() {
        this.checkReady();
        return this.mBlockId;
    }

    public long getLength() {
        this.checkReady();
        return this.mLength;
    }

    int getLockId() {
        return this.mLockId;
    }

    public long getOffset() {
        this.checkReady();
        return this.mOffset;
    }

    public ByteBuffer getReadOnlyData() {
        this.checkReady();
        ByteBuffer ret = this.mData.asReadOnlyBuffer();
        ret.flip();
        return ret;
    }

    public boolean isMessageReady() {
        return this.mIsMessageReady;
    }

    private void isSend(boolean isSend) {
        if (this.mToSendData != isSend) {
            if (this.mToSendData) {
                throw new RuntimeException("Try to recv on send message");
            }
            throw new RuntimeException("Try to send on recv message");
        }
    }

    public int recv(SocketChannel socketChannel) throws IOException {
        this.isSend(false);
        int numRead = 0;
        if (this.mHeader.remaining() > 0) {
            numRead = socketChannel.read(this.mHeader);
            if (this.mHeader.remaining() == 0) {
                this.mHeader.flip();
                short msgType = this.mHeader.getShort();
                assert (this.mMessageType == msgType);
                this.mBlockId = this.mHeader.getLong();
                this.mOffset = this.mHeader.getLong();
                this.mLength = this.mHeader.getLong();
                assert (this.mLength < Integer.MAX_VALUE);
                if (this.mMessageType == 2) {
                    this.mData = this.mLength == -1L ? ByteBuffer.allocate(0) : ByteBuffer.allocate((int)this.mLength);
                }
                LOG.info("data {}, blockId:{} offset:{} dataLength:{}", new Object[]{this.mData, this.mBlockId, this.mOffset, this.mLength});
                if (this.mMessageType == 1 || this.mLength <= 0L) {
                    this.mIsMessageReady = true;
                }
            }
        } else {
            numRead = socketChannel.read(this.mData);
            if (this.mData.remaining() == 0) {
                this.mIsMessageReady = true;
            }
        }
        return numRead;
    }

    public void send(SocketChannel socketChannel) throws IOException {
        this.isSend(true);
        socketChannel.write(this.mHeader);
        if (this.mHeader.remaining() == 0) {
            socketChannel.write(this.mData);
        }
    }

    void setLockId(int lockId) {
        this.mLockId = lockId;
    }
}

