/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker.netty;

import com.google.common.base.Throwables;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import tachyon.conf.WorkerConf;
import tachyon.util.ThreadFactoryUtils;
import tachyon.worker.BlocksLocker;
import tachyon.worker.DataServer;
import tachyon.worker.netty.ChannelType;
import tachyon.worker.netty.PipelineHandler;

public final class NettyDataServer
implements DataServer {
    private final ServerBootstrap mBootstrap;
    private final ChannelFuture mChannelFuture;

    public NettyDataServer(SocketAddress address, BlocksLocker locker) {
        this.mBootstrap = this.createBootstrap().childHandler((ChannelHandler)new PipelineHandler(locker));
        try {
            this.mChannelFuture = this.mBootstrap.bind(address).sync();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.mChannelFuture.channel().close().awaitUninterruptibly();
        this.mBootstrap.group().shutdownGracefully();
        this.mBootstrap.childGroup().shutdownGracefully();
    }

    private ServerBootstrap createBootstrap() {
        WorkerConf conf = WorkerConf.get();
        ServerBootstrap boot = new ServerBootstrap();
        boot = this.setupGroups(boot, conf.NETTY_CHANNEL_TYPE);
        boot.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        boot.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        boot.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)conf.NETTY_HIGH_WATER_MARK);
        boot.childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)conf.NETTY_LOW_WATER_MARK);
        if (conf.NETTY_BACKLOG.isPresent()) {
            boot.option(ChannelOption.SO_BACKLOG, conf.NETTY_BACKLOG.get());
        }
        if (conf.NETTY_SEND_BUFFER.isPresent()) {
            boot.option(ChannelOption.SO_SNDBUF, conf.NETTY_SEND_BUFFER.get());
        }
        if (conf.NETTY_RECIEVE_BUFFER.isPresent()) {
            boot.option(ChannelOption.SO_RCVBUF, conf.NETTY_RECIEVE_BUFFER.get());
        }
        return boot;
    }

    @Override
    public int getPort() {
        return ((InetSocketAddress)this.mChannelFuture.channel().localAddress()).getPort();
    }

    @Override
    public boolean isClosed() {
        return this.mBootstrap.group().isShutdown();
    }

    private ServerBootstrap setupGroups(ServerBootstrap boot, ChannelType type) {
        EpollEventLoopGroup workerGroup;
        EpollEventLoopGroup bossGroup;
        ThreadFactory bossThreadFactory = ThreadFactoryUtils.build("data-server-boss-%d");
        ThreadFactory workerThreadFactory = ThreadFactoryUtils.build("data-server-worker-%d");
        int bossThreadCount = WorkerConf.get().NETTY_BOSS_THREADS;
        int workerThreadCount = WorkerConf.get().NETTY_WORKER_THREADS;
        switch (type) {
            case EPOLL: {
                bossGroup = new EpollEventLoopGroup(bossThreadCount, bossThreadFactory);
                workerGroup = new EpollEventLoopGroup(workerThreadCount, workerThreadFactory);
                boot.channel(EpollServerSocketChannel.class);
                break;
            }
            default: {
                bossGroup = new NioEventLoopGroup(bossThreadCount, bossThreadFactory);
                workerGroup = new NioEventLoopGroup(workerThreadCount, workerThreadFactory);
                boot.channel(NioServerSocketChannel.class);
            }
        }
        boot.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup);
        return boot;
    }
}

