/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tachyon.TachyonURI;
import tachyon.master.MasterInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.InvalidPathException;
import tachyon.web.UiFileInfo;

public class WebInterfaceMemoryServlet
extends HttpServlet {
    private static final long serialVersionUID = 4293149962399443914L;
    private final transient MasterInfo mMasterInfo;

    public WebInterfaceMemoryServlet(MasterInfo masterInfo) {
        this.mMasterInfo = masterInfo;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("masterNodeAddress", (Object)this.mMasterInfo.getMasterAddress().toString());
        request.setAttribute("fatalError", (Object)"");
        List<TachyonURI> inMemoryFiles = this.mMasterInfo.getInMemoryFiles();
        Collections.sort(inMemoryFiles);
        ArrayList<UiFileInfo> fileInfos = new ArrayList<UiFileInfo>(inMemoryFiles.size());
        for (TachyonURI file : inMemoryFiles) {
            try {
                ClientFileInfo fileInfo = this.mMasterInfo.getClientFileInfo(file);
                if (fileInfo == null || fileInfo.getInMemoryPercentage() != 100) continue;
                fileInfos.add(new UiFileInfo(fileInfo));
            }
            catch (InvalidPathException ipe) {
                request.setAttribute("fatalError", (Object)("Error: Invalid Path " + ipe.getLocalizedMessage()));
                this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        request.setAttribute("inMemoryFileNum", (Object)fileInfos.size());
        if (request.getParameter("offset") == null && request.getParameter("limit") == null) {
            this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            int offset = Integer.parseInt(request.getParameter("offset"));
            int limit = Integer.parseInt(request.getParameter("limit"));
            List sub = fileInfos.subList(offset, offset + limit);
            request.setAttribute("fileInfos", sub);
        }
        catch (NumberFormatException nfe) {
            request.setAttribute("fatalError", (Object)("Error: offset or limit parse error, " + nfe.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IndexOutOfBoundsException iobe) {
            request.setAttribute("fatalError", (Object)("Error: offset or offset + limit is out of bound, " + iobe.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IllegalArgumentException iae) {
            request.setAttribute("fatalError", (Object)iae.getLocalizedMessage());
            this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

