/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tachyon.master.MasterInfo;
import tachyon.thrift.ClientDependencyInfo;
import tachyon.thrift.DependencyDoesNotExistException;
import tachyon.thrift.FileDoesNotExistException;

public class WebInterfaceDependencyServlet
extends HttpServlet {
    private static final long serialVersionUID = 2071462168900313417L;
    private final transient MasterInfo mMasterInfo;

    public WebInterfaceDependencyServlet(MasterInfo masterInfo) {
        this.mMasterInfo = masterInfo;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("masterNodeAddress", (Object)this.mMasterInfo.getMasterAddress().toString());
        request.setAttribute("filePath", (Object)request.getParameter("filePath"));
        request.setAttribute("error", (Object)"");
        int dependencyId = Integer.parseInt(request.getParameter("id"));
        ArrayList<String> parentFileNames = new ArrayList<String>();
        ArrayList<String> childrenFileNames = new ArrayList<String>();
        try {
            ClientDependencyInfo dependencyInfo = this.mMasterInfo.getClientDependencyInfo(dependencyId);
            for (int pId : dependencyInfo.parents) {
                parentFileNames.add(this.mMasterInfo.getPath(pId).toString());
            }
            for (int cId : dependencyInfo.children) {
                childrenFileNames.add(this.mMasterInfo.getPath(cId).toString());
            }
        }
        catch (DependencyDoesNotExistException ddnee) {
            request.setAttribute("error", (Object)ddnee.getMessage());
        }
        catch (FileDoesNotExistException fdne) {
            request.setAttribute("error", (Object)fdne.getMessage());
        }
        Collections.sort(parentFileNames);
        Collections.sort(childrenFileNames);
        request.setAttribute("parentFileNames", parentFileNames);
        request.setAttribute("childrenFileNames", childrenFileNames);
        this.getServletContext().getRequestDispatcher("/dependency.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

