/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

abstract class JsonObject {
    private static final ObjectMapper OBJECT_MAPPER = JsonObject.createObjectMapper();
    public Map<String, JsonNode> mParameters = Maps.newHashMap();

    JsonObject() {
    }

    public static ObjectMapper createObjectMapper() {
        return new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false).configure(SerializationFeature.CLOSE_CLOSEABLE, false);
    }

    public <T> T get(String name, Class<T> clazz) {
        return (T)OBJECT_MAPPER.convertValue((Object)this.mParameters.get(name), clazz);
    }

    public <T> T get(String name, TypeReference<T> typeReference) {
        return (T)OBJECT_MAPPER.convertValue((Object)this.mParameters.get(name), typeReference);
    }

    public Boolean getBoolean(String name) {
        return this.get(name, Boolean.class);
    }

    public ByteBuffer getByteBuffer(String name) {
        String byteString = this.get(name, String.class);
        if (byteString == null) {
            return null;
        }
        return ByteBuffer.wrap(Base64.decodeBase64((String)byteString));
    }

    public List<ByteBuffer> getByteBufferList(String name) {
        List<String> byteStrings = this.get(name, new TypeReference<List<String>>(){});
        if (byteStrings == null) {
            return null;
        }
        ArrayList buffers = Lists.newArrayListWithCapacity((int)byteStrings.size());
        for (String byteString : byteStrings) {
            buffers.add(ByteBuffer.wrap(Base64.decodeBase64((String)byteString)));
        }
        return buffers;
    }

    public Integer getInt(String name) {
        return this.get(name, Number.class).intValue();
    }

    public Long getLong(String name) {
        return this.get(name, Number.class).longValue();
    }

    public String getString(String name) {
        return this.get(name, String.class);
    }

    public JsonObject withParameter(String name, Object value) {
        this.mParameters.put(name, (JsonNode)OBJECT_MAPPER.convertValue(value, JsonNode.class));
        return this;
    }
}

