/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Throwables;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.Pair;
import tachyon.TachyonURI;
import tachyon.UnderFileSystem;
import tachyon.io.Utils;
import tachyon.master.DependencyType;
import tachyon.master.EditLogOperation;
import tachyon.master.EditLogOperationType;
import tachyon.master.JsonObject;
import tachyon.master.MasterInfo;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.FileAlreadyExistException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.thrift.SuspectedFileSizeException;
import tachyon.thrift.TableDoesNotExistException;
import tachyon.thrift.TachyonException;
import tachyon.util.CommonUtils;

public final class EditLog {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static int sBackUpLogStartNum = -1;
    private static long sCurrentTId = 0L;
    private final boolean mInactive;
    private final String mPath;
    private final ObjectWriter mWriter;
    private UnderFileSystem mUfs;
    private OutputStream mOs;
    private DataOutputStream mDos;
    private long mFlushedTransactionId = 0L;
    private long mTransactionId = 0L;
    private int mCurrentLogFileNum = 0;
    private int mMaxLogSize = 0x500000;

    public static long load(MasterInfo info, String path, int currentLogFileNum) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        if (!ufs.exists(path)) {
            LOG.info("Edit Log " + path + " does not exist.");
            return 0L;
        }
        LOG.info("currentLogNum passed in was " + currentLogFileNum);
        int completedLogs = currentLogFileNum;
        sBackUpLogStartNum = currentLogFileNum;
        String completedPath = path.substring(0, path.lastIndexOf("/") + 1) + "completed";
        if (!ufs.exists(completedPath)) {
            LOG.info("No completed edit logs to be parsed");
        } else {
            String curEditLogFile = CommonUtils.concat(completedPath, completedLogs + ".editLog");
            while (ufs.exists(curEditLogFile)) {
                LOG.info("Loading Edit Log " + curEditLogFile);
                EditLog.loadSingleLog(info, curEditLogFile);
                curEditLogFile = CommonUtils.concat(completedPath, ++completedLogs + ".editLog");
            }
        }
        LOG.info("Loading Edit Log " + path);
        EditLog.loadSingleLog(info, path);
        ufs.close();
        return sCurrentTId;
    }

    public static void loadSingleLog(MasterInfo info, String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        DataInputStream is = new DataInputStream(ufs.open(path));
        JsonParser parser = JsonObject.createObjectMapper().getFactory().createParser((InputStream)is);
        while (true) {
            EditLogOperation op;
            try {
                op = (EditLogOperation)parser.readValueAs(EditLogOperation.class);
                LOG.debug("Read operation: {}", (Object)op);
            }
            catch (IOException e) {
                if (e.getMessage().contains("end-of-input")) break;
                throw e;
            }
            sCurrentTId = op.mTransId;
            try {
                switch (op.mType) {
                    case ADD_BLOCK: {
                        info.opAddBlock(op.getInt("fileId"), op.getInt("blockIndex"), op.getLong("blockLength"), op.getLong("opTimeMs"));
                        break;
                    }
                    case ADD_CHECKPOINT: {
                        info._addCheckpoint(-1L, op.getInt("fileId"), op.getLong("length"), new TachyonURI(op.getString("path")), op.getLong("opTimeMs"));
                        break;
                    }
                    case CREATE_FILE: {
                        info._createFile(op.getBoolean("recursive"), new TachyonURI(op.getString("path")), op.getBoolean("directory"), op.getLong("blockSizeByte"), op.getLong("creationTimeMs"));
                        break;
                    }
                    case COMPLETE_FILE: {
                        info._completeFile(op.get("fileId", Integer.class), op.getLong("opTimeMs"));
                        break;
                    }
                    case SET_PINNED: {
                        info._setPinned(op.getInt("fileId"), op.getBoolean("pinned"), op.getLong("opTimeMs"));
                        break;
                    }
                    case RENAME: {
                        info._rename(op.getInt("fileId"), new TachyonURI(op.getString("dstPath")), op.getLong("opTimeMs"));
                        break;
                    }
                    case DELETE: {
                        info._delete(op.getInt("fileId"), op.getBoolean("recursive"), op.getLong("opTimeMs"));
                        break;
                    }
                    case CREATE_RAW_TABLE: {
                        info._createRawTable(op.getInt("tableId"), op.getInt("columns"), op.getByteBuffer("metadata"));
                        break;
                    }
                    case UPDATE_RAW_TABLE_METADATA: {
                        info.updateRawTableMetadata(op.getInt("tableId"), op.getByteBuffer("metadata"));
                        break;
                    }
                    case CREATE_DEPENDENCY: {
                        info._createDependency(op.get("parents", new TypeReference<List<Integer>>(){}), op.get("children", new TypeReference<List<Integer>>(){}), op.getString("commandPrefix"), op.getByteBufferList("data"), op.getString("comment"), op.getString("framework"), op.getString("frameworkVersion"), op.get("dependencyType", DependencyType.class), op.getInt("dependencyId"), op.getLong("creationTimeMs"));
                        break;
                    }
                    default: {
                        throw new IOException("Invalid op type " + op);
                    }
                }
            }
            catch (SuspectedFileSizeException e) {
                throw new IOException(e);
            }
            catch (BlockInfoException e) {
                throw new IOException(e);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TableDoesNotExistException e) {
                throw new IOException(e);
            }
        }
        is.close();
        ufs.close();
    }

    public static void markUpToDate(String path) {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        String folder = path.substring(0, path.lastIndexOf("/") + 1) + "completed";
        try {
            String toDelete = CommonUtils.concat(folder, sBackUpLogStartNum + ".editLog");
            while (ufs.exists(toDelete)) {
                LOG.info("Deleting editlog " + toDelete);
                ufs.delete(toDelete, true);
                toDelete = CommonUtils.concat(folder, ++sBackUpLogStartNum + ".editLog");
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        sBackUpLogStartNum = -1;
    }

    public EditLog(String path, boolean inactive, long transactionId) throws IOException {
        this.mInactive = inactive;
        if (!this.mInactive) {
            LOG.info("Creating edit log file " + path);
            this.mPath = path;
            this.mUfs = UnderFileSystem.get(path);
            if (sBackUpLogStartNum != -1) {
                LOG.info("Deleting completed editlogs that are part of the image.");
                this.deleteCompletedLogs(path, sBackUpLogStartNum);
                LOG.info("Backing up logs from " + sBackUpLogStartNum + " since image is not updated.");
                String folder = path.substring(0, path.lastIndexOf("/") + 1) + "/completed";
                this.mUfs.mkdirs(folder, true);
                String toRename = CommonUtils.concat(folder, sBackUpLogStartNum + ".editLog");
                int currentLogFileNum = 0;
                String dstPath = CommonUtils.concat(folder, currentLogFileNum + ".editLog");
                while (this.mUfs.exists(toRename)) {
                    this.mUfs.rename(toRename, dstPath);
                    LOG.info("Rename " + toRename + " to " + dstPath);
                    toRename = CommonUtils.concat(folder, ++sBackUpLogStartNum + ".editLog");
                    dstPath = CommonUtils.concat(folder, ++currentLogFileNum + ".editLog");
                }
                if (this.mUfs.exists(path)) {
                    dstPath = CommonUtils.concat(folder, currentLogFileNum + ".editLog");
                    this.mUfs.rename(path, dstPath);
                    LOG.info("Rename " + path + " to " + dstPath);
                    ++currentLogFileNum;
                }
                sBackUpLogStartNum = -1;
            }
            if (this.mUfs.exists(path)) {
                this.mUfs.delete(path, true);
            }
            this.mOs = this.mUfs.create(path);
            this.mDos = new DataOutputStream(this.mOs);
            LOG.info("Created file " + path);
            this.mFlushedTransactionId = transactionId;
            this.mTransactionId = transactionId;
            this.mWriter = JsonObject.createObjectMapper().writer();
        } else {
            this.mPath = null;
            this.mUfs = null;
            this.mOs = null;
            this.mDos = null;
            this.mWriter = null;
        }
    }

    private synchronized void _closeActiveStream() {
        try {
            if (this.mDos != null) {
                this.mDos.close();
            }
            if (this.mOs != null) {
                this.mOs.close();
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public synchronized void addBlock(int fileId, int blockIndex, long blockLength, long opTimeMs) {
        if (this.mInactive) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.ADD_BLOCK, ++this.mTransactionId).withParameter("fileId", fileId).withParameter("blockIndex", blockIndex).withParameter("blockLength", blockLength).withParameter("opTimeMs", opTimeMs);
        this.writeOperation(operation);
    }

    public synchronized void addCheckpoint(int fileId, long length, TachyonURI checkpointPath, long opTimeMs) {
        if (this.mInactive) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.ADD_CHECKPOINT, ++this.mTransactionId).withParameter("fileId", fileId).withParameter("length", length).withParameter("path", checkpointPath.toString()).withParameter("opTimeMs", opTimeMs);
        this.writeOperation(operation);
    }

    public synchronized void close() {
        if (this.mInactive) {
            return;
        }
        try {
            this._closeActiveStream();
            this.mUfs.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public synchronized void completeFile(int fileId, long opTimeMs) {
        if (this.mInactive) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.COMPLETE_FILE, ++this.mTransactionId).withParameter("fileId", fileId).withParameter("opTimeMs", opTimeMs);
        this.writeOperation(operation);
    }

    public synchronized void createDependency(List<Integer> parents, List<Integer> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, DependencyType dependencyType, int depId, long creationTimeMs) {
        if (this.mInactive) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.CREATE_DEPENDENCY, ++this.mTransactionId).withParameter("parents", parents).withParameter("children", children).withParameter("commandPrefix", commandPrefix).withParameter("data", Utils.byteBufferListToBase64(data)).withParameter("comment", comment).withParameter("framework", framework).withParameter("frameworkVersion", frameworkVersion).withParameter("dependencyType", (Object)dependencyType).withParameter("dependencyId", depId).withParameter("creationTimeMs", creationTimeMs);
        this.writeOperation(operation);
    }

    public synchronized void createFile(boolean recursive, TachyonURI path, boolean directory, long blockSizeByte, long creationTimeMs) {
        if (this.mInactive) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.CREATE_FILE, ++this.mTransactionId).withParameter("recursive", recursive).withParameter("path", path.toString()).withParameter("directory", directory).withParameter("blockSizeByte", blockSizeByte).withParameter("creationTimeMs", creationTimeMs);
        this.writeOperation(operation);
    }

    public synchronized void createRawTable(int tableId, int columns, ByteBuffer metadata) {
        if (this.mInactive) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.CREATE_RAW_TABLE, ++this.mTransactionId).withParameter("tableId", tableId).withParameter("columns", columns).withParameter("metadata", Utils.byteBufferToBase64(metadata));
        this.writeOperation(operation);
    }

    public synchronized void delete(int fileId, boolean recursive, long opTimeMs) {
        if (this.mInactive) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.DELETE, ++this.mTransactionId).withParameter("fileId", fileId).withParameter("recursive", recursive).withParameter("opTimeMs", opTimeMs);
        this.writeOperation(operation);
    }

    public void deleteCompletedLogs(String path, int upTo) {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        String folder = path.substring(0, path.lastIndexOf("/") + 1) + "completed";
        try {
            for (int i = 0; i < upTo; ++i) {
                String toDelete = CommonUtils.concat(folder, i + ".editLog");
                LOG.info("Deleting editlog " + toDelete);
                ufs.delete(toDelete, true);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public synchronized void flush() {
        if (this.mInactive) {
            return;
        }
        try {
            this.mDos.flush();
            if (this.mOs instanceof FSDataOutputStream) {
                ((FSDataOutputStream)this.mOs).sync();
            }
            if (this.mDos.size() > this.mMaxLogSize) {
                this.rotateEditLog(this.mPath);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.mFlushedTransactionId = this.mTransactionId;
    }

    public synchronized Pair<Long, Long> getTransactionIds() {
        return new Pair<Long, Long>(this.mTransactionId, this.mFlushedTransactionId);
    }

    public synchronized void rename(int fileId, TachyonURI dstPath, long opTimeMs) {
        if (this.mInactive) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.RENAME, ++this.mTransactionId).withParameter("fileId", fileId).withParameter("dstPath", dstPath.toString()).withParameter("opTimeMs", opTimeMs);
        this.writeOperation(operation);
    }

    public void rotateEditLog(String path) {
        if (this.mInactive) {
            return;
        }
        this._closeActiveStream();
        LOG.info("Edit log max size of " + this.mMaxLogSize + " bytes reached, rotating edit log");
        String pathPrefix = path.substring(0, path.lastIndexOf("/") + 1) + "completed";
        LOG.info("path: " + path + " prefix: " + pathPrefix);
        try {
            if (!this.mUfs.exists(pathPrefix)) {
                this.mUfs.mkdirs(pathPrefix, true);
            }
            String newPath = CommonUtils.concat(pathPrefix, this.mCurrentLogFileNum++ + ".editLog");
            this.mUfs.rename(path, newPath);
            LOG.info("Renamed " + path + " to " + newPath);
            this.mOs = this.mUfs.create(path);
            this.mDos = new DataOutputStream(this.mOs);
            LOG.info("Created new log file " + path);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    void setMaxLogSize(int size) {
        this.mMaxLogSize = size;
    }

    static void setBackUpLogStartNum(int num) {
        sBackUpLogStartNum = num;
    }

    public synchronized void setPinned(int fileId, boolean pinned, long opTimeMs) {
        if (this.mInactive) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.SET_PINNED, ++this.mTransactionId).withParameter("fileId", fileId).withParameter("pinned", pinned).withParameter("opTimeMs", opTimeMs);
        this.writeOperation(operation);
    }

    public synchronized void updateRawTableMetadata(int tableId, ByteBuffer metadata) {
        if (this.mInactive) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.UPDATE_RAW_TABLE_METADATA, ++this.mTransactionId).withParameter("tableId", tableId).withParameter("metadata", Utils.byteBufferToBase64(metadata));
        this.writeOperation(operation);
    }

    private void writeOperation(EditLogOperation operation) {
        try {
            this.mWriter.writeValue((OutputStream)this.mDos, (Object)operation);
            this.mDos.writeByte(10);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

