/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.conf.MasterConf;
import tachyon.io.Utils;
import tachyon.master.DependencyType;
import tachyon.master.DependencyVariables;
import tachyon.master.ImageElement;
import tachyon.master.ImageElementType;
import tachyon.master.ImageWriter;
import tachyon.thrift.ClientDependencyInfo;
import tachyon.util.CommonUtils;

public class Dependency
extends ImageWriter {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    public final int mId;
    public final long mCreationTimeMs;
    public final List<Integer> mParentFiles;
    public final List<Integer> mChildrenFiles;
    private final Set<Integer> mUncheckpointedChildrenFiles;
    public final String mCommandPrefix;
    public final List<ByteBuffer> mData;
    public final String mComment;
    public final String mFramework;
    public final String mFrameworkVersion;
    public final DependencyType mDependencyType;
    public final List<Integer> mParentDependencies;
    private final List<Integer> mChildrenDependencies;
    private final Set<Integer> mLostFileIds;

    static Dependency loadImage(ImageElement ele) throws IOException {
        Dependency dep = new Dependency(ele.getInt("depID"), ele.get("parentFiles", new TypeReference<List<Integer>>(){}), ele.get("childrenFiles", new TypeReference<List<Integer>>(){}), ele.getString("commandPrefix"), ele.getByteBufferList("data"), ele.getString("comment"), ele.getString("framework"), ele.getString("frameworkVersion"), ele.get("dependencyType", DependencyType.class), (Collection<Integer>)ele.get("parentDeps", new TypeReference<List<Integer>>(){}), ele.getLong("creationTimeMs"));
        dep.resetUncheckpointedChildrenFiles((Collection<Integer>)ele.get("unCheckpointedChildrenFiles", new TypeReference<List<Integer>>(){}));
        return dep;
    }

    public Dependency(int id, List<Integer> parents, List<Integer> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, DependencyType type, Collection<Integer> parentDependencies, long creationTimeMs) {
        this.mId = id;
        this.mCreationTimeMs = creationTimeMs;
        this.mParentFiles = new ArrayList<Integer>(parents.size());
        this.mParentFiles.addAll(parents);
        this.mChildrenFiles = new ArrayList<Integer>(children.size());
        this.mChildrenFiles.addAll(children);
        this.mUncheckpointedChildrenFiles = new HashSet<Integer>();
        this.mUncheckpointedChildrenFiles.addAll(this.mChildrenFiles);
        this.mCommandPrefix = commandPrefix;
        this.mData = CommonUtils.cloneByteBufferList(data);
        this.mComment = comment;
        this.mFramework = framework;
        this.mFrameworkVersion = frameworkVersion;
        this.mDependencyType = type;
        this.mParentDependencies = new ArrayList<Integer>(parentDependencies.size());
        this.mParentDependencies.addAll(parentDependencies);
        this.mChildrenDependencies = new ArrayList<Integer>(0);
        this.mLostFileIds = new HashSet<Integer>(0);
    }

    public synchronized void addChildrenDependency(int childDependencyId) {
        for (int dependencyId : this.mChildrenDependencies) {
            if (dependencyId != childDependencyId) continue;
            return;
        }
        this.mChildrenDependencies.add(childDependencyId);
    }

    public synchronized void addLostFile(int fileId) {
        this.mLostFileIds.add(fileId);
    }

    public synchronized void childCheckpointed(int childFileId) {
        this.mUncheckpointedChildrenFiles.remove(childFileId);
        LOG.debug("Child got checkpointed {} : {}", (Object)childFileId, (Object)this.toString());
    }

    public ClientDependencyInfo generateClientDependencyInfo() {
        ClientDependencyInfo ret = new ClientDependencyInfo();
        ret.id = this.mId;
        ret.parents = new ArrayList<Integer>(this.mParentFiles.size());
        ret.parents.addAll(this.mParentFiles);
        ret.children = new ArrayList<Integer>(this.mChildrenFiles.size());
        ret.children.addAll(this.mChildrenFiles);
        ret.data = CommonUtils.cloneByteBufferList(this.mData);
        return ret;
    }

    public synchronized List<Integer> getChildrenDependency() {
        ArrayList<Integer> ret = new ArrayList<Integer>(this.mChildrenDependencies.size());
        ret.addAll(this.mChildrenDependencies);
        return ret;
    }

    public synchronized String getCommand() {
        StringBuilder sb = new StringBuilder(this.parseCommandPrefix());
        sb.append(" ").append(MasterConf.get().MASTER_ADDRESS);
        sb.append(" ").append(this.mId);
        for (int k = 0; k < this.mChildrenFiles.size(); ++k) {
            int id = this.mChildrenFiles.get(k);
            if (!this.mLostFileIds.contains(id)) continue;
            sb.append(" ").append(k);
        }
        this.mLostFileIds.clear();
        return sb.toString();
    }

    public synchronized List<Integer> getLostFiles() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ret.addAll(this.mLostFileIds);
        return ret;
    }

    synchronized List<Integer> getUncheckpointedChildrenFiles() {
        ArrayList<Integer> ret = new ArrayList<Integer>(this.mUncheckpointedChildrenFiles.size());
        ret.addAll(this.mUncheckpointedChildrenFiles);
        return ret;
    }

    public synchronized boolean hasCheckpointed() {
        return this.mUncheckpointedChildrenFiles.size() == 0;
    }

    public synchronized boolean hasChildrenDependency() {
        return !this.mChildrenDependencies.isEmpty();
    }

    public synchronized boolean hasLostFile() {
        return !this.mLostFileIds.isEmpty();
    }

    String parseCommandPrefix() {
        String rtn = this.mCommandPrefix;
        for (String s : DependencyVariables.VARIABLES.keySet()) {
            rtn = rtn.replace("$" + s, DependencyVariables.VARIABLES.get(s));
        }
        return rtn;
    }

    synchronized void resetUncheckpointedChildrenFiles(Collection<Integer> uckdChildrenFiles) {
        this.mUncheckpointedChildrenFiles.clear();
        this.mUncheckpointedChildrenFiles.addAll(uckdChildrenFiles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Dependency[");
        sb.append("Id:").append(this.mId).append(", CreationTimeMs:").append(this.mCreationTimeMs);
        sb.append(", Parents:").append(this.mParentFiles).append(", Children:").append(this.mChildrenFiles);
        sb.append(", CommandPrefix:").append(this.mCommandPrefix);
        sb.append(", ParsedCommandPrefix:").append(this.parseCommandPrefix());
        sb.append(", Comment:").append(this.mComment);
        sb.append(", Framework:").append(this.mFramework);
        sb.append(", FrameworkVersion:").append(this.mFrameworkVersion);
        sb.append(", ParentDependencies:").append(this.mParentDependencies);
        sb.append(", ChildrenDependencies:").append(this.mChildrenDependencies);
        sb.append(", UncheckpointedChildrenFiles:").append(this.mUncheckpointedChildrenFiles);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public synchronized void writeImage(ObjectWriter objWriter, DataOutputStream dos) throws IOException {
        ImageElement ele = new ImageElement(ImageElementType.Dependency).withParameter("depID", this.mId).withParameter("parentFiles", this.mParentFiles).withParameter("childrenFiles", this.mChildrenFiles).withParameter("commandPrefix", this.mCommandPrefix).withParameter("data", Utils.byteBufferListToBase64(this.mData)).withParameter("comment", this.mComment).withParameter("framework", this.mFramework).withParameter("frameworkVersion", this.mFrameworkVersion).withParameter("depType", (Object)this.mDependencyType).withParameter("parentDeps", this.mParentDependencies).withParameter("creationTimeMs", this.mCreationTimeMs).withParameter("unCheckpointedChildrenFiles", this.getUncheckpointedChildrenFiles());
        this.writeElement(objWriter, dos, ele);
    }
}

