/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tachyon.Pair;
import tachyon.StorageDirId;
import tachyon.StorageLevelAlias;
import tachyon.UnderFileSystem;
import tachyon.master.InodeFile;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.NetAddress;
import tachyon.util.NetworkUtils;

public class BlockInfo {
    private final InodeFile mInodeFile;
    public final int mBlockIndex;
    public final long mBlockId;
    public final long mOffset;
    public final long mLength;
    private final Map<Long, NetAddress> mLocations = new HashMap<Long, NetAddress>(5);
    private final Map<NetAddress, Long> mStorageDirIds = new HashMap<NetAddress, Long>(5);

    public static long computeBlockId(int inodeId, int blockIndex) {
        return ((long)inodeId << 30) + (long)blockIndex;
    }

    public static int computeBlockIndex(long blockId) {
        return (int)(blockId & 0x3FFFFFFFL);
    }

    public static int computeInodeId(long blockId) {
        return (int)(blockId >> 30);
    }

    BlockInfo(InodeFile inodeFile, int blockIndex, long length) {
        this.mInodeFile = inodeFile;
        this.mBlockIndex = blockIndex;
        this.mBlockId = BlockInfo.computeBlockId(this.mInodeFile.getId(), this.mBlockIndex);
        this.mOffset = inodeFile.getBlockSizeByte() * (long)blockIndex;
        this.mLength = length;
    }

    public synchronized void addLocation(long workerId, NetAddress workerAddress, long storageDirId) {
        this.mLocations.put(workerId, workerAddress);
        this.mStorageDirIds.put(workerAddress, storageDirId);
    }

    public synchronized ClientBlockInfo generateClientBlockInfo() {
        ClientBlockInfo ret = new ClientBlockInfo();
        ret.blockId = this.mBlockId;
        ret.offset = this.mOffset;
        ret.length = this.mLength;
        ret.locations = this.getLocations();
        return ret;
    }

    public synchronized List<Pair<Long, Long>> getBlockIdWorkerIdPairs() {
        ArrayList<Pair<Long, Long>> ret = new ArrayList<Pair<Long, Long>>(this.mLocations.size());
        for (long workerId : this.mLocations.keySet()) {
            ret.add(new Pair<Long, Long>(this.mBlockId, workerId));
        }
        return ret;
    }

    public synchronized InodeFile getInodeFile() {
        return this.mInodeFile;
    }

    public synchronized List<NetAddress> getLocations() {
        ArrayList<NetAddress> ret = new ArrayList<NetAddress>(this.mLocations.size());
        ret.addAll(this.mLocations.values());
        if (ret.isEmpty() && this.mInodeFile.hasCheckpointed()) {
            UnderFileSystem ufs = UnderFileSystem.get(this.mInodeFile.getUfsPath());
            List<String> locs = null;
            try {
                locs = ufs.getFileLocations(this.mInodeFile.getUfsPath(), this.mOffset);
            }
            catch (IOException e) {
                return ret;
            }
            if (locs != null) {
                for (String loc : locs) {
                    String resolvedHost;
                    try {
                        resolvedHost = NetworkUtils.resolveHostName(loc);
                    }
                    catch (UnknownHostException e) {
                        resolvedHost = loc;
                    }
                    ret.add(new NetAddress(resolvedHost, -1, -1));
                }
            }
        }
        return ret;
    }

    public synchronized boolean isInMemory() {
        for (long storageDirId : this.mStorageDirIds.values()) {
            int storageLevelValue = StorageDirId.getStorageLevelAliasValue(storageDirId);
            if (storageLevelValue != StorageLevelAlias.MEM.getValue()) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeLocation(long workerId) {
        if (this.mLocations.containsKey(workerId)) {
            this.mStorageDirIds.remove(this.mLocations.remove(workerId));
        }
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("BlockInfo(mBlockIndex: ");
        sb.append(this.mBlockIndex);
        sb.append(", mBlockId: ").append(this.mBlockId);
        sb.append(", mOffset: ").append(this.mOffset);
        sb.append(", mLength: ").append(this.mLength);
        sb.append(", mLocations: ").append(this.mLocations).append(")");
        return sb.toString();
    }
}

