/*
 * Decompiled with CFR 0.152.
 */
package tachyon.io;

import com.google.common.collect.Lists;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class Utils {
    public static List<String> byteBufferListToBase64(List<ByteBuffer> bufs) {
        if (bufs == null) {
            return null;
        }
        ArrayList bytes = Lists.newArrayListWithCapacity((int)bufs.size());
        for (ByteBuffer buf : bufs) {
            bytes.add(Utils.byteBufferToBase64(buf));
        }
        return bytes;
    }

    public static String byteBufferToBase64(ByteBuffer buf) {
        if (buf == null) {
            return null;
        }
        if (buf.hasArray() && buf.position() == 0 && buf.limit() == buf.capacity()) {
            return Base64.encodeBase64String((byte[])buf.array());
        }
        byte[] b = new byte[buf.remaining()];
        buf.get(b);
        return Base64.encodeBase64String((byte[])b);
    }

    public static ByteBuffer readByteBuffer(DataInputStream is) throws IOException {
        int len = is.readInt();
        if (len == -1) {
            return null;
        }
        byte[] arr = new byte[len];
        for (int k = 0; k < len; ++k) {
            arr[k] = is.readByte();
        }
        return ByteBuffer.wrap(arr);
    }

    public static List<ByteBuffer> readByteBufferList(DataInputStream is) throws IOException {
        int size = is.readInt();
        if (size == -1) {
            return null;
        }
        ArrayList<ByteBuffer> ret = new ArrayList<ByteBuffer>(size);
        for (int k = 0; k < size; ++k) {
            ret.add(Utils.readByteBuffer(is));
        }
        return ret;
    }

    public static List<Integer> readIntegerList(DataInputStream is) throws IOException {
        int size = is.readInt();
        if (size == -1) {
            return null;
        }
        ArrayList<Integer> ret = new ArrayList<Integer>(size);
        for (int k = 0; k < size; ++k) {
            ret.add(is.readInt());
        }
        return ret;
    }

    public static String readString(DataInputStream is) throws IOException {
        int len = is.readInt();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        char[] chars = new char[len];
        for (int k = 0; k < len; ++k) {
            chars[k] = is.readChar();
        }
        return new String(chars);
    }

    public static List<String> readStringList(DataInputStream is) throws IOException {
        int size = is.readInt();
        if (size == -1) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>(size);
        for (int k = 0; k < size; ++k) {
            ret.add(Utils.readString(is));
        }
        return ret;
    }

    public static void writeByteBuffer(ByteBuffer buf, DataOutputStream os) throws IOException {
        if (buf == null) {
            os.writeInt(-1);
            return;
        }
        int len = buf.limit() - buf.position();
        os.writeInt(len);
        os.write(buf.array(), buf.position(), len);
    }

    public static void writeByteBufferList(List<ByteBuffer> list, DataOutputStream os) throws IOException {
        if (list == null) {
            os.writeInt(-1);
            return;
        }
        os.writeInt(list.size());
        for (int k = 0; k < list.size(); ++k) {
            Utils.writeByteBuffer(list.get(k), os);
        }
    }

    public static void writeIntegerList(List<Integer> list, DataOutputStream os) throws IOException {
        if (list == null) {
            os.writeInt(-1);
            return;
        }
        os.writeInt(list.size());
        for (int k = 0; k < list.size(); ++k) {
            os.writeInt(list.get(k));
        }
    }

    public static void writeString(String str, DataOutputStream os) throws IOException {
        if (str == null) {
            os.writeInt(-1);
        } else {
            os.writeInt(str.length());
            os.writeChars(str);
        }
    }

    public static void writeStringList(List<String> list, DataOutputStream os) throws IOException {
        if (list == null) {
            os.writeInt(-1);
            return;
        }
        os.writeInt(list.size());
        for (int k = 0; k < list.size(); ++k) {
            Utils.writeString(list.get(k), os);
        }
    }
}

