/*
 * Decompiled with CFR 0.152.
 */
package tachyon.examples;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.Version;
import tachyon.client.OutStream;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.client.table.RawColumn;
import tachyon.client.table.RawTable;
import tachyon.examples.Utils;

public class BasicRawTableOperations
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static final int COLS = 3;
    private final TachyonURI mMasterAddress;
    private final TachyonURI mTablePath;
    private final WriteType mWriteType;
    private final int mDataLength = 20;
    private final int mMetadataLength = 5;
    private int mId;

    public BasicRawTableOperations(TachyonURI masterAddress, TachyonURI tablePath, WriteType writeType) {
        this.mMasterAddress = masterAddress;
        this.mTablePath = tablePath;
        this.mWriteType = writeType;
    }

    @Override
    public Boolean call() throws Exception {
        TachyonFS tachyonClient = TachyonFS.get(this.mMasterAddress);
        this.createRawTable(tachyonClient);
        this.write(tachyonClient);
        return this.read(tachyonClient);
    }

    private void createRawTable(TachyonFS tachyonClient) throws IOException {
        ByteBuffer data = ByteBuffer.allocate(20);
        data.order(ByteOrder.nativeOrder());
        for (int k = -5; k < 0; ++k) {
            data.putInt(k);
        }
        data.flip();
        this.mId = tachyonClient.createRawTable(this.mTablePath, 3, data);
    }

    private boolean read(TachyonFS tachyonClient) throws IOException {
        boolean pass = true;
        LOG.debug("Reading data...");
        RawTable rawTable = tachyonClient.getRawTable(this.mId);
        ByteBuffer metadata = rawTable.getMetadata();
        LOG.debug("Metadata: ");
        metadata.order(ByteOrder.nativeOrder());
        for (int k = -5; k < 0; ++k) {
            pass = pass && metadata.getInt() == k;
        }
        for (int column = 0; column < 3; ++column) {
            RawColumn rawColumn = rawTable.getRawColumn(column);
            TachyonFile tFile = rawColumn.getPartition(0);
            TachyonByteBuffer buf = tFile.readByteBuffer(0);
            if (buf == null) {
                tFile.recache();
                buf = tFile.readByteBuffer(0);
            }
            buf.mData.order(ByteOrder.nativeOrder());
            for (int k = 0; k < 20; ++k) {
                pass = pass && buf.mData.getInt() == k;
            }
            buf.close();
        }
        return pass;
    }

    private void write(TachyonFS tachyonClient) throws IOException {
        RawTable rawTable = tachyonClient.getRawTable(this.mTablePath);
        LOG.debug("Writing data...");
        for (int column = 0; column < 3; ++column) {
            RawColumn rawColumn = rawTable.getRawColumn(column);
            if (!rawColumn.createPartition(0)) {
                throw new IOException("Failed to create partition in table " + this.mTablePath + " under column " + column);
            }
            ByteBuffer buf = ByteBuffer.allocate(80);
            buf.order(ByteOrder.nativeOrder());
            for (int k = 0; k < 20; ++k) {
                buf.putInt(k);
            }
            buf.flip();
            TachyonFile tFile = rawColumn.getPartition(0);
            OutStream os = tFile.getOutStream(this.mWriteType);
            os.write(buf.array());
            os.close();
        }
    }

    public static void main(String[] args) throws IllegalArgumentException {
        if (args.length != 3) {
            System.out.println("java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar " + "tachyon.examples.BasicRawTableOperations <TachyonMasterAddress> <FilePath>");
            System.exit(-1);
        }
        Utils.runExample(new BasicRawTableOperations(new TachyonURI(args[0]), new TachyonURI(args[1]), WriteType.valueOf(args[2])));
    }
}

