/*
 * Decompiled with CFR 0.152.
 */
package tachyon.conf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.conf.Utils;

public class CommonConf
extends Utils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"");
    private static CommonConf sCommonConf = null;
    public static final ImmutableList<String> DEFAULT_HADOOP_UFS_PREFIX = ImmutableList.of((Object)"hdfs://", (Object)"s3://", (Object)"s3n://", (Object)"glusterfs:///");
    private static final String DEFAULT_HOME = "/mnt/tachyon_default_home";
    public final String TACHYON_HOME;
    public final String UNDERFS_ADDRESS;
    public final String UNDERFS_DATA_FOLDER;
    public final String UNDERFS_WORKERS_FOLDER;
    public final String UNDERFS_HDFS_IMPL;
    public final String UNDERFS_GLUSTERFS_IMPL;
    public final String UNDERFS_GLUSTERFS_VOLUMES;
    public final String UNDERFS_GLUSTERFS_MOUNTS;
    public final String UNDERFS_GLUSTERFS_MR_DIR;
    public final String WEB_RESOURCES;
    public final boolean USE_ZOOKEEPER;
    public final String ZOOKEEPER_ADDRESS;
    public final String ZOOKEEPER_ELECTION_PATH;
    public final String ZOOKEEPER_LEADER_PATH;
    public final boolean ASYNC_ENABLED;
    public final int MAX_COLUMNS;
    public final int MAX_TABLE_METADATA_BYTE;
    public final ImmutableList<String> HADOOP_UFS_PREFIXES;
    public final boolean IN_TEST_MODE;
    public final int MASTER_RETRY_COUNT;

    public static synchronized void clear() {
        sCommonConf = null;
    }

    public static synchronized CommonConf get() {
        if (sCommonConf == null) {
            sCommonConf = new CommonConf();
        }
        return sCommonConf;
    }

    private CommonConf() {
        if (System.getProperty("tachyon.home") == null) {
            LOG.warn("tachyon.home is not set. Using {} as the default value.", (Object)DEFAULT_HOME);
            File file = new File(DEFAULT_HOME);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        this.TACHYON_HOME = CommonConf.getProperty("tachyon.home", DEFAULT_HOME);
        this.WEB_RESOURCES = CommonConf.getProperty("tachyon.web.resources", this.TACHYON_HOME + "/core/src/main/webapp");
        this.UNDERFS_ADDRESS = CommonConf.getProperty("tachyon.underfs.address", this.TACHYON_HOME + "/underfs");
        this.UNDERFS_DATA_FOLDER = CommonConf.getProperty("tachyon.data.folder", this.UNDERFS_ADDRESS + "/tachyon/data");
        this.UNDERFS_WORKERS_FOLDER = CommonConf.getProperty("tachyon.workers.folder", this.UNDERFS_ADDRESS + "/tachyon/workers");
        this.UNDERFS_HDFS_IMPL = CommonConf.getProperty("tachyon.underfs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
        this.UNDERFS_GLUSTERFS_IMPL = CommonConf.getProperty("tachyon.underfs.glusterfs.impl", "org.apache.hadoop.fs.glusterfs.GlusterFileSystem");
        this.UNDERFS_GLUSTERFS_VOLUMES = CommonConf.getProperty("tachyon.underfs.glusterfs.volumes", null);
        this.UNDERFS_GLUSTERFS_MOUNTS = CommonConf.getProperty("tachyon.underfs.glusterfs.mounts", null);
        this.UNDERFS_GLUSTERFS_MR_DIR = CommonConf.getProperty("tachyon.underfs.glusterfs.mapred.system.dir", "glusterfs:///mapred/system");
        this.USE_ZOOKEEPER = CommonConf.getBooleanProperty("tachyon.usezookeeper", false);
        if (this.USE_ZOOKEEPER) {
            this.ZOOKEEPER_ADDRESS = CommonConf.getProperty("tachyon.zookeeper.address");
            this.ZOOKEEPER_ELECTION_PATH = CommonConf.getProperty("tachyon.zookeeper.election.path", "/election");
            this.ZOOKEEPER_LEADER_PATH = CommonConf.getProperty("tachyon.zookeeper.leader.path", "/leader");
        } else {
            this.ZOOKEEPER_ADDRESS = null;
            this.ZOOKEEPER_ELECTION_PATH = null;
            this.ZOOKEEPER_LEADER_PATH = null;
        }
        this.ASYNC_ENABLED = CommonConf.getBooleanProperty("tachyon.async.enabled", false);
        this.MAX_COLUMNS = CommonConf.getIntProperty("tachyon.max.columns", 1000);
        this.MAX_TABLE_METADATA_BYTE = CommonConf.getIntProperty("tachyon.max.table.metadata.byte", 0x500000);
        this.HADOOP_UFS_PREFIXES = CommonConf.getListProperty("tachyon.underfs.hadoop.prefixes", DEFAULT_HADOOP_UFS_PREFIX);
        this.IN_TEST_MODE = CommonConf.getBooleanProperty("tachyon.test.mode", false);
        this.MASTER_RETRY_COUNT = CommonConf.getIntProperty("tachyon.master.retry", 29);
    }

    public static void assertValidPort(int port) {
        if (!CommonConf.get().IN_TEST_MODE) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port is only allowed to be zero in test mode.");
        }
    }

    public static void assertValidPort(InetSocketAddress address) {
        CommonConf.assertValidPort(address.getPort());
    }
}

