/*
 * Decompiled with CFR 0.152.
 */
package tachyon.command;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.List;
import tachyon.TachyonURI;
import tachyon.client.InStream;
import tachyon.client.OutStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.command.Utils;
import tachyon.conf.UserConf;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.util.CommonUtils;

public class TFsShell
implements Closeable {
    private final Closer mCloser = Closer.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws IOException {
        int ret;
        TFsShell shell = new TFsShell();
        try {
            ret = shell.run(argv);
        }
        finally {
            shell.close();
        }
        System.exit(ret);
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cat(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs cat <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        TachyonFile tFile = tachyonClient.getFile(path);
        if (tFile == null) {
            System.out.println(path + " does not exist.");
            return -1;
        }
        if (tFile.isFile()) {
            InStream is = tFile.getInStream(ReadType.NO_CACHE);
            byte[] buf = new byte[512];
            try {
                int read = is.read(buf);
                while (read != -1) {
                    System.out.write(buf, 0, read);
                    read = is.read(buf);
                }
            }
            finally {
                is.close();
            }
            return 0;
        }
        System.out.println(path + " is not a file.");
        return -1;
    }

    public int copyFromLocal(String[] argv) throws IOException {
        if (argv.length != 3) {
            System.out.println("Usage: tfs copyFromLocal <src> <remoteDst>");
            return -1;
        }
        String srcPath = argv[1];
        TachyonURI dstPath = new TachyonURI(argv[2]);
        File src = new File(srcPath);
        if (!src.exists()) {
            System.out.println("Local path " + srcPath + " does not exist.");
            return -1;
        }
        TachyonFS tachyonClient = this.createFS(dstPath);
        int ret = this.copyPath(src, tachyonClient, dstPath);
        if (ret == 0) {
            System.out.println("Copied " + srcPath + " to " + dstPath);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyPath(File src, TachyonFS tachyonClient, TachyonURI dstPath) throws IOException {
        if (!src.isDirectory()) {
            int fileId;
            TachyonFile tFile = tachyonClient.getFile(dstPath);
            if (tFile != null && tFile.isDirectory()) {
                dstPath = dstPath.join(src.getName());
            }
            if ((fileId = tachyonClient.createFile(dstPath)) == -1) {
                return -1;
            }
            tFile = tachyonClient.getFile(fileId);
            Closer closer = Closer.create();
            try {
                OutStream os = (OutStream)closer.register((Closeable)tFile.getOutStream(UserConf.get().DEFAULT_WRITE_TYPE));
                FileInputStream in = (FileInputStream)closer.register((Closeable)new FileInputStream(src));
                FileChannel channel = (FileChannel)closer.register((Closeable)in.getChannel());
                ByteBuffer buf = ByteBuffer.allocate(0x800000);
                while (channel.read(buf) != -1) {
                    buf.flip();
                    os.write(buf.array(), 0, buf.limit());
                }
            }
            finally {
                closer.close();
            }
            return 0;
        }
        tachyonClient.mkdir(dstPath);
        for (String file : src.list()) {
            File srcFile = new File(src, file);
            TachyonURI newPath = new TachyonURI(dstPath, new TachyonURI(file));
            if (this.copyPath(srcFile, tachyonClient, newPath) != -1) continue;
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyToLocal(String[] argv) throws IOException {
        if (argv.length != 3) {
            System.out.println("Usage: tfs copyToLocal <src> <localdst>");
            return -1;
        }
        TachyonURI srcPath = new TachyonURI(argv[1]);
        String dstPath = argv[2];
        File dst = new File(dstPath);
        TachyonFS tachyonClient = this.createFS(srcPath);
        TachyonFile tFile = tachyonClient.getFile(srcPath);
        if (tFile == null) {
            throw new IOException(srcPath.toString());
        }
        Closer closer = Closer.create();
        try {
            InStream is = (InStream)closer.register((Closeable)tFile.getInStream(ReadType.NO_CACHE));
            FileOutputStream out = (FileOutputStream)closer.register((Closeable)new FileOutputStream(dst));
            byte[] buf = new byte[0x4000000];
            int t = is.read(buf);
            while (t != -1) {
                out.write(buf, 0, t);
                t = is.read(buf);
            }
            System.out.println("Copied " + srcPath + " to " + dstPath);
            int n = 0;
            return n;
        }
        finally {
            closer.close();
        }
    }

    public int count(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs count <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        try {
            long[] values = this.countHelper(path);
            String format = "%-25s%-25s%-15s%n";
            System.out.format(format, "File Count", "Folder Count", "Total Bytes");
            System.out.format(format, values[0], values[1], values[2]);
        }
        catch (FileDoesNotExistException e) {
            System.out.println(e.getMessage() + " does not exist.");
            return -1;
        }
        return 0;
    }

    private long[] countHelper(TachyonURI path) throws FileDoesNotExistException, IOException {
        TachyonFS tachyonClient = this.createFS(path);
        TachyonFile tFile = tachyonClient.getFile(path);
        if (tFile == null) {
            throw new FileDoesNotExistException(path.toString());
        }
        if (tFile.isFile()) {
            return new long[]{1L, 0L, tFile.length()};
        }
        long[] rtn = new long[]{0L, 1L, 0L};
        List<ClientFileInfo> files = tachyonClient.listStatus(path);
        Collections.sort(files);
        for (ClientFileInfo file : files) {
            long[] toAdd = this.countHelper(new TachyonURI(file.getPath()));
            rtn[0] = rtn[0] + toAdd[0];
            rtn[1] = rtn[1] + toAdd[1];
            rtn[2] = rtn[2] + toAdd[2];
        }
        return rtn;
    }

    public int fileinfo(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs fileinfo <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        int fileId = tachyonClient.getFileId(path);
        if (fileId == -1) {
            System.out.println(path + " does not exist.");
            return -1;
        }
        List<ClientBlockInfo> blocks = tachyonClient.getFileBlocks(fileId);
        System.out.println(path + " with file id " + fileId + " has the following blocks: ");
        for (ClientBlockInfo block : blocks) {
            System.out.println(block);
        }
        return 0;
    }

    public int location(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs location <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        int fileId = tachyonClient.getFileId(path);
        if (fileId == -1) {
            System.out.println(path + " does not exist.");
            return -1;
        }
        List<String> hosts = tachyonClient.getFile(fileId).getLocationHosts();
        System.out.println(path + " with file id " + fileId + " is on nodes: ");
        for (String host : hosts) {
            System.out.println(host);
        }
        return 0;
    }

    public int ls(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs ls <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        List<ClientFileInfo> files = tachyonClient.listStatus(path);
        Collections.sort(files);
        String format = "%-10s%-25s%-15s%-5s%n";
        for (ClientFileInfo file : files) {
            String inMemory = "";
            if (!file.isFolder) {
                inMemory = 100 == file.inMemoryPercentage ? "In Memory" : "Not In Memory";
            }
            System.out.format(format, CommonUtils.getSizeFromBytes(file.getLength()), CommonUtils.convertMsToDate(file.getCreationTimeMs()), inMemory, file.getPath());
        }
        return 0;
    }

    public int lsr(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs lsr <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        List<ClientFileInfo> files = tachyonClient.listStatus(path);
        Collections.sort(files);
        String format = "%-10s%-25s%-15s%-5s%n";
        for (ClientFileInfo file : files) {
            String inMemory = "";
            if (!file.isFolder) {
                inMemory = 100 == file.inMemoryPercentage ? "In Memory" : "Not In Memory";
            }
            System.out.format(format, CommonUtils.getSizeFromBytes(file.getLength()), CommonUtils.convertMsToDate(file.getCreationTimeMs()), inMemory, file.getPath());
            if (!file.isFolder) continue;
            this.lsr(new String[]{"lsr", file.getPath()});
        }
        return 0;
    }

    public int mkdir(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs mkdir <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        if (tachyonClient.mkdir(path)) {
            System.out.println("Successfully created directory " + path);
            return 0;
        }
        return -1;
    }

    public int pin(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs pin <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        int fileId = tachyonClient.getFileId(path);
        try {
            tachyonClient.pinFile(fileId);
            System.out.println("File '" + path + "' was successfully pinned.");
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("File '" + path + "' could not be pinned.");
            return -1;
        }
    }

    public void printUsage() {
        System.out.println("Usage: java TFsShell");
        System.out.println("       [cat <path>]");
        System.out.println("       [count <path>]");
        System.out.println("       [ls <path>]");
        System.out.println("       [lsr <path>]");
        System.out.println("       [mkdir <path>]");
        System.out.println("       [rm <path>]");
        System.out.println("       [rmr <path>]");
        System.out.println("       [tail <path>]");
        System.out.println("       [touch <path>]");
        System.out.println("       [mv <src> <dst>]");
        System.out.println("       [copyFromLocal <src> <remoteDst>]");
        System.out.println("       [copyToLocal <src> <localDst>]");
        System.out.println("       [fileinfo <path>]");
        System.out.println("       [location <path>]");
        System.out.println("       [report <path>]");
        System.out.println("       [request <tachyonaddress> <dependencyId>]");
        System.out.println("       [pin <path>]");
        System.out.println("       [unpin <path>]");
        System.out.println("       [free <file path|folder path>]");
    }

    public int rename(String[] argv) throws IOException {
        if (argv.length != 3) {
            System.out.println("Usage: tfs mv <src> <dst>");
            return -1;
        }
        TachyonURI srcPath = new TachyonURI(argv[1]);
        TachyonURI dstPath = new TachyonURI(argv[2]);
        TachyonFS tachyonClient = this.createFS(srcPath);
        if (tachyonClient.rename(srcPath, dstPath)) {
            System.out.println("Renamed " + srcPath + " to " + dstPath);
            return 0;
        }
        return -1;
    }

    public int report(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs report <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        int fileId = tachyonClient.getFileId(path);
        tachyonClient.reportLostFile(fileId);
        System.out.println(path + " with file id " + fileId + " has reported been report lost.");
        return 0;
    }

    public int request(String[] argv) throws IOException {
        if (argv.length != 3) {
            System.out.println("Usage: tfs request <tachyonaddress> <dependencyId>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        int depId = Integer.parseInt(argv[2]);
        TachyonFS tachyonClient = this.createFS(path);
        tachyonClient.requestFilesInDependency(depId);
        System.out.println("Dependency with ID " + depId + " has been requested.");
        return 0;
    }

    public int rm(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs rm <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        TachyonFile tFile = tachyonClient.getFile(path);
        if (tFile != null && tFile.isDirectory()) {
            System.out.println("can't remove a directory, please try rmr <path>");
            return -1;
        }
        if (tachyonClient.delete(path, false)) {
            System.out.println(path + " has been removed");
            return 0;
        }
        return -1;
    }

    public int rmr(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs rmr <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        if (tachyonClient.delete(path, true)) {
            System.out.println(path + " has been removed");
            return 0;
        }
        return -1;
    }

    public int run(String[] argv) {
        int exitCode;
        block22: {
            if (argv.length == 0) {
                this.printUsage();
                return -1;
            }
            String cmd = argv[0];
            exitCode = -1;
            try {
                if (cmd.equals("cat")) {
                    exitCode = this.cat(argv);
                    break block22;
                }
                if (cmd.equals("count")) {
                    exitCode = this.count(argv);
                    break block22;
                }
                if (cmd.equals("ls")) {
                    exitCode = this.ls(argv);
                    break block22;
                }
                if (cmd.equals("lsr")) {
                    exitCode = this.lsr(argv);
                    break block22;
                }
                if (cmd.equals("mkdir")) {
                    exitCode = this.mkdir(argv);
                    break block22;
                }
                if (cmd.equals("rm")) {
                    exitCode = this.rm(argv);
                    break block22;
                }
                if (cmd.equals("rmr")) {
                    exitCode = this.rmr(argv);
                    break block22;
                }
                if (cmd.equals("tail")) {
                    exitCode = this.tail(argv);
                    break block22;
                }
                if (cmd.equals("mv")) {
                    exitCode = this.rename(argv);
                    break block22;
                }
                if (cmd.equals("touch")) {
                    exitCode = this.touch(argv);
                    break block22;
                }
                if (cmd.equals("copyFromLocal")) {
                    exitCode = this.copyFromLocal(argv);
                    break block22;
                }
                if (cmd.equals("copyToLocal")) {
                    exitCode = this.copyToLocal(argv);
                    break block22;
                }
                if (cmd.equals("fileinfo")) {
                    exitCode = this.fileinfo(argv);
                    break block22;
                }
                if (cmd.equals("location")) {
                    exitCode = this.location(argv);
                    break block22;
                }
                if (cmd.equals("report")) {
                    exitCode = this.report(argv);
                    break block22;
                }
                if (cmd.equals("request")) {
                    exitCode = this.request(argv);
                    break block22;
                }
                if (cmd.equals("pin")) {
                    exitCode = this.pin(argv);
                    break block22;
                }
                if (cmd.equals("unpin")) {
                    exitCode = this.unpin(argv);
                    break block22;
                }
                if (cmd.equals("free")) {
                    exitCode = this.free(argv);
                    break block22;
                }
                this.printUsage();
                return -1;
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tail(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs tail <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        TachyonFile tFile = tachyonClient.getFile(path);
        if (tFile == null) {
            System.out.println(path + " does not exist.");
            return -1;
        }
        if (tFile.isFile()) {
            InStream is = tFile.getInStream(ReadType.NO_CACHE);
            try {
                byte[] buf = new byte[1024];
                long bytesToRead = 0L;
                bytesToRead = tFile.length() > 1024L ? 1024L : tFile.length();
                is.skip(tFile.length() - bytesToRead);
                int read = is.read(buf);
                System.out.write(buf, 0, read);
                int n = 0;
                return n;
            }
            finally {
                is.close();
            }
        }
        System.out.println(path + " is not a file.");
        return -1;
    }

    public int touch(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs touch <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        TachyonFile tFile = tachyonClient.getFile(tachyonClient.createFile(path));
        OutStream out = tFile.getOutStream(WriteType.THROUGH);
        ((OutputStream)out).close();
        System.out.println(path + " has been created");
        return 0;
    }

    public int unpin(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs unpin <path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        int fileId = tachyonClient.getFileId(path);
        try {
            tachyonClient.unpinFile(fileId);
            System.out.println("File '" + path + "' was successfully unpinned.");
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("File '" + path + "' could not be unpinned.");
            return -1;
        }
    }

    public int free(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs free <file path | folder path>");
            return -1;
        }
        TachyonURI path = new TachyonURI(argv[1]);
        TachyonFS tachyonClient = this.createFS(path);
        if (tachyonClient.freepath(path, true)) {
            System.out.println(path + " was successfully freed from memory.");
            return 0;
        }
        return -1;
    }

    private TachyonFS createFS(TachyonURI path) throws IOException {
        String qualifiedPath = Utils.validatePath(path.toString());
        return (TachyonFS)this.mCloser.register((Closeable)TachyonFS.get(new TachyonURI(qualifiedPath)));
    }
}

