/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import tachyon.client.TachyonFS;

public class TachyonByteBuffer
implements Closeable {
    public final ByteBuffer mData;
    private final long mBlockId;
    private final int mBlockLockId;
    private final TachyonFS mTachyonFS;
    private boolean mClosed = false;

    TachyonByteBuffer(TachyonFS tfs, ByteBuffer buf, long blockId, int blockLockId) {
        this.mData = buf;
        this.mBlockId = blockId;
        this.mBlockLockId = blockLockId;
        this.mTachyonFS = tfs;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        if (this.mBlockLockId >= 0) {
            this.mTachyonFS.unlockBlock(this.mBlockId, this.mBlockLockId);
        }
    }
}

