/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.OutStream;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.conf.UserConf;
import tachyon.util.CommonUtils;

public class BlockOutStream
extends OutStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final int mBlockIndex;
    private final long mBlockCapacityByte;
    private final long mBlockId;
    private final long mBlockOffset;
    private final boolean mPin;
    private final Closer mCloser = Closer.create();
    private final String mLocalFilePath;
    private final RandomAccessFile mLocalFile;
    private final FileChannel mLocalFileChannel;
    private final ByteBuffer mBuffer;
    private long mAvailableBytes = 0L;
    private long mInFileBytes = 0L;
    private long mWrittenBytes = 0L;
    private boolean mCanWrite = false;
    private boolean mClosed = false;

    BlockOutStream(TachyonFile file, WriteType opType, int blockIndex) throws IOException {
        this(file, opType, blockIndex, UserConf.get().QUOTA_UNIT_BYTES);
    }

    BlockOutStream(TachyonFile file, WriteType opType, int blockIndex, long initialBytes) throws IOException {
        super(file, opType);
        if (!opType.isCache()) {
            throw new IOException("BlockOutStream only support WriteType.CACHE");
        }
        this.mBlockIndex = blockIndex;
        this.mBlockCapacityByte = this.mFile.getBlockSizeByte();
        this.mBlockId = this.mFile.getBlockId(this.mBlockIndex);
        this.mBlockOffset = this.mBlockCapacityByte * (long)blockIndex;
        this.mPin = this.mFile.needPin();
        this.mCanWrite = true;
        if (!this.mTachyonFS.hasLocalWorker()) {
            this.mCanWrite = false;
            String msg = "The machine does not have any local worker.";
            throw new IOException(msg);
        }
        this.mLocalFilePath = this.mTachyonFS.getLocalBlockTemporaryPath(this.mBlockId, initialBytes);
        this.mLocalFile = (RandomAccessFile)this.mCloser.register((Closeable)new RandomAccessFile(this.mLocalFilePath, "rw"));
        this.mLocalFileChannel = (FileChannel)this.mCloser.register((Closeable)this.mLocalFile.getChannel());
        CommonUtils.changeLocalFileToFullPermission(this.mLocalFilePath);
        CommonUtils.setLocalFileStickyBit(this.mLocalFilePath);
        LOG.info(this.mLocalFilePath + " was created!");
        this.mAvailableBytes += initialBytes;
        this.mBuffer = ByteBuffer.allocate(this.mUserConf.FILE_BUFFER_BYTES + 4);
    }

    private synchronized void appendCurrentBuffer(byte[] buf, int offset, int length) throws IOException {
        if (this.mAvailableBytes < (long)length) {
            long bytesRequested = this.mTachyonFS.requestSpace(this.mBlockId, (long)length - this.mAvailableBytes);
            if (bytesRequested + this.mAvailableBytes >= (long)length) {
                this.mAvailableBytes += bytesRequested;
            } else {
                this.mCanWrite = false;
                throw new IOException(String.format("No enough space on local worker: fileId(%d) blockId(%d) requestSize(%d)", this.mFile.mFileId, this.mBlockId, (long)length - this.mAvailableBytes));
            }
        }
        MappedByteBuffer out = this.mLocalFileChannel.map(FileChannel.MapMode.READ_WRITE, this.mInFileBytes, length);
        out.put(buf, offset, length);
        this.mInFileBytes += (long)length;
        this.mAvailableBytes -= (long)length;
    }

    @Override
    public void cancel() throws IOException {
        if (!this.mClosed) {
            this.mCloser.close();
            this.mClosed = true;
            this.mTachyonFS.cancelBlock(this.mBlockId);
            LOG.info(String.format("Canceled output of block. blockId(%d) path(%s)", this.mBlockId, this.mLocalFilePath));
        }
    }

    public boolean canWrite() {
        return !this.mClosed && this.mCanWrite;
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            if (this.mBuffer.position() > 0) {
                this.appendCurrentBuffer(this.mBuffer.array(), 0, this.mBuffer.position());
            }
            this.mCloser.close();
            this.mTachyonFS.cacheBlock(this.mBlockId);
            this.mClosed = true;
        }
    }

    @Override
    public void flush() throws IOException {
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public long getBlockOffset() {
        return this.mBlockOffset;
    }

    public long getRemainingSpaceByte() {
        return this.mBlockCapacityByte - this.mWrittenBytes;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException(String.format("Buffer length (%d), offset(%d), len(%d)", b.length, off, len));
        }
        if (!this.canWrite()) {
            throw new IOException("Can not write cache.");
        }
        if (this.mWrittenBytes + (long)len > this.mBlockCapacityByte) {
            throw new IOException("Out of capacity.");
        }
        if (this.mBuffer.position() + len >= this.mUserConf.FILE_BUFFER_BYTES && this.mBuffer.position() > 0) {
            this.appendCurrentBuffer(this.mBuffer.array(), 0, this.mBuffer.position());
            this.mBuffer.clear();
        }
        if (len >= this.mUserConf.FILE_BUFFER_BYTES) {
            this.appendCurrentBuffer(b, off, len);
        } else {
            this.mBuffer.put(b, off, len);
        }
        this.mWrittenBytes += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.canWrite()) {
            throw new IOException("Can not write cache.");
        }
        if (this.mWrittenBytes + 1L > this.mBlockCapacityByte) {
            throw new IOException("Out of capacity.");
        }
        if (this.mBuffer.position() >= this.mUserConf.FILE_BUFFER_BYTES) {
            this.appendCurrentBuffer(this.mBuffer.array(), 0, this.mBuffer.position());
            this.mBuffer.clear();
        }
        this.mBuffer.put((byte)(b & 0xFF));
        ++this.mWrittenBytes;
    }
}

