/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.UserInfo;
import tachyon.conf.CommonConf;
import tachyon.util.CommonUtils;

public class Users {
    public static final int DATASERVER_USER_ID = -1;
    public static final int CHECKPOINT_USER_ID = -2;
    public static final int MIGRATE_DATA_USER_ID = -3;
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final String mUserUnderFSFolder;
    private final Map<Long, UserInfo> mUsers;

    public Users(String userUfsFolder) {
        this.mUserUnderFSFolder = userUfsFolder;
        this.mUsers = new HashMap<Long, UserInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> checkStatus() {
        LOG.debug("Worker is checking all users' status.");
        ArrayList<Long> ret = new ArrayList<Long>();
        Map<Long, UserInfo> map = this.mUsers;
        synchronized (map) {
            for (Map.Entry<Long, UserInfo> entry : this.mUsers.entrySet()) {
                if (!entry.getValue().timeout()) continue;
                ret.add(entry.getKey());
            }
        }
        return ret;
    }

    public String getUserUfsTempFolder(long userId) {
        return CommonUtils.concat(this.mUserUnderFSFolder, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeUser(long userId) {
        StringBuilder sb = new StringBuilder("Trying to cleanup user " + userId + " : ");
        UserInfo tUser = null;
        Map<Long, UserInfo> map = this.mUsers;
        synchronized (map) {
            tUser = this.mUsers.get(userId);
            this.mUsers.remove(userId);
        }
        if (tUser == null) {
            sb.append(" The user does not exist in the worker's current user pool.");
        } else {
            String folder = this.getUserUfsTempFolder(userId);
            sb.append(" Remove users underfs folder ").append(folder);
            try {
                UnderFileSystem.get(CommonConf.get().UNDERFS_ADDRESS).delete(folder, true);
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        LOG.info(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userHeartbeat(long userId) {
        Map<Long, UserInfo> map = this.mUsers;
        synchronized (map) {
            if (this.mUsers.containsKey(userId)) {
                this.mUsers.get(userId).heartbeat();
            } else {
                this.mUsers.put(userId, new UserInfo(userId));
            }
        }
    }
}

