/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import java.net.URI;
import java.net.URISyntaxException;

public final class TachyonURI
implements Comparable<TachyonURI> {
    public static final String SEPARATOR = "/";
    public static final String CUR_DIR = ".";
    public static final TachyonURI EMPTY_URI = new TachyonURI("");
    private static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private final URI mUri;

    public TachyonURI(String pathStr) {
        if (pathStr == null) {
            throw new IllegalArgumentException("Can not create a uri with a null path.");
        }
        if (this.hasWindowsDrive(pathStr, false)) {
            pathStr = SEPARATOR + pathStr;
        }
        String scheme = null;
        String authority = null;
        int start = 0;
        int colon = pathStr.indexOf(58);
        int slash = pathStr.indexOf(47);
        if (colon != -1 && (slash == -1 || colon < slash)) {
            scheme = pathStr.substring(0, colon);
            start = colon + 1;
        }
        if (pathStr.startsWith("//", start) && pathStr.length() - start > 2) {
            int nextSlash = pathStr.indexOf(47, start + 2);
            int authEnd = nextSlash > 0 ? nextSlash : pathStr.length();
            authority = pathStr.substring(start + 2, authEnd);
            start = authEnd;
        }
        String path = pathStr.substring(start, pathStr.length());
        this.mUri = this.createURI(scheme, authority, path);
    }

    public TachyonURI(String scheme, String authority, String path) {
        if (path == null) {
            throw new IllegalArgumentException("Can not create a uri with a null path.");
        }
        this.mUri = this.createURI(scheme, authority, path);
    }

    public TachyonURI(TachyonURI parent, TachyonURI child) {
        URI parentUri = parent.mUri;
        String parentPath = parentUri.getPath();
        if (!parentPath.endsWith(SEPARATOR) && parentPath.length() > 0) {
            parentPath = parentPath + SEPARATOR;
        }
        try {
            parentUri = new URI(parentUri.getScheme(), parentUri.getAuthority(), parentPath, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        URI resolved = parentUri.resolve(child.mUri);
        this.mUri = this.createURI(resolved.getScheme(), resolved.getAuthority(), resolved.getPath());
    }

    @Override
    public int compareTo(TachyonURI other) {
        return this.mUri.compareTo(other.mUri);
    }

    private URI createURI(String scheme, String authority, String path) throws IllegalArgumentException {
        try {
            return new URI(scheme, authority, this.normalizePath(path), null, null).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof TachyonURI)) {
            return false;
        }
        return this.mUri.equals(((TachyonURI)o).mUri);
    }

    public String getAuthority() {
        return this.mUri.getAuthority();
    }

    public int getDepth() {
        int slash;
        String path = this.mUri.getPath();
        if (path.isEmpty()) {
            return 0;
        }
        int depth = 0;
        int n = slash = path.length() == 1 && path.charAt(0) == '/' ? -1 : 0;
        while (slash != -1) {
            ++depth;
            slash = path.indexOf(SEPARATOR, slash + 1);
        }
        return depth;
    }

    public String getHost() {
        return this.mUri.getHost();
    }

    public String getName() {
        String path = this.mUri.getPath();
        int slash = path.lastIndexOf(SEPARATOR);
        return path.substring(slash + 1);
    }

    public TachyonURI getParent() {
        String parent;
        int start;
        String path = this.mUri.getPath();
        int lastSlash = path.lastIndexOf(47);
        int n = start = this.hasWindowsDrive(path, true) ? 3 : 0;
        if (path.length() == start || lastSlash == start && path.length() == start + 1) {
            return null;
        }
        if (lastSlash == -1) {
            parent = CUR_DIR;
        } else {
            int end = this.hasWindowsDrive(path, true) ? 3 : 0;
            parent = path.substring(0, lastSlash == end ? end + 1 : lastSlash);
        }
        return new TachyonURI(this.mUri.getScheme(), this.mUri.getAuthority(), parent);
    }

    public String getPath() {
        return this.mUri.getPath();
    }

    public int getPort() {
        return this.mUri.getPort();
    }

    public String getScheme() {
        return this.mUri.getScheme();
    }

    public boolean hasAuthority() {
        return this.mUri.getAuthority() != null;
    }

    public int hashCode() {
        return this.mUri.hashCode();
    }

    public boolean hasScheme() {
        return this.mUri.getScheme() != null;
    }

    private boolean hasWindowsDrive(String path, boolean slashed) {
        int start = slashed ? 1 : 0;
        return WINDOWS && path.length() >= start + 2 && (!slashed || path.charAt(0) == '/') && path.charAt(start + 1) == ':' && (path.charAt(start) >= 'A' && path.charAt(start) <= 'Z' || path.charAt(start) >= 'a' && path.charAt(start) <= 'z');
    }

    public boolean isAbsolute() {
        return this.mUri.isAbsolute();
    }

    public boolean isPathAbsolute() {
        int start = this.hasWindowsDrive(this.mUri.getPath(), true) ? 3 : 0;
        return this.mUri.getPath().startsWith(SEPARATOR, start);
    }

    public boolean isRoot() {
        return this.mUri.getPath().equals(SEPARATOR) || this.mUri.getPath().isEmpty() && this.mUri.getAuthority() != null;
    }

    public TachyonURI join(String suffix) {
        return new TachyonURI(this.getScheme(), this.getAuthority(), this.getPath() + SEPARATOR + suffix);
    }

    public TachyonURI join(TachyonURI suffix) {
        return this.join(suffix.toString());
    }

    private String normalizePath(String path) {
        int minLength;
        while (path.indexOf("\\") != -1) {
            path = path.replace("\\", SEPARATOR);
        }
        while (path.indexOf("//") != -1) {
            path = path.replace("//", SEPARATOR);
        }
        int n = minLength = this.hasWindowsDrive(path, true) ? 4 : 1;
        while (path.length() > minLength && path.endsWith(SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.mUri.getScheme() != null) {
            sb.append(this.mUri.getScheme());
            sb.append("://");
        }
        if (this.mUri.getAuthority() != null) {
            if (this.mUri.getScheme() == null) {
                sb.append("//");
            }
            sb.append(this.mUri.getAuthority());
        }
        if (this.mUri.getPath() != null) {
            String path = this.mUri.getPath();
            if (path.indexOf(47) == 0 && this.hasWindowsDrive(path, true) && this.mUri.getScheme() == null && this.mUri.getAuthority() == null) {
                path = path.substring(1);
            }
            sb.append(path);
        }
        return sb.toString();
    }
}

