/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.HeartbeatExecutor;
import tachyon.master.MasterClient;

class MasterClientHeartbeatExecutor
implements HeartbeatExecutor {
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final MasterClient CLIENT;
    private final long MAX_NONE_ACCESS_INTERVAL;

    public MasterClientHeartbeatExecutor(MasterClient client, long maxNoneAccessIntervalMs) {
        this.CLIENT = client;
        this.MAX_NONE_ACCESS_INTERVAL = maxNoneAccessIntervalMs;
    }

    @Override
    public void heartbeat() {
        long internalMs = System.currentTimeMillis() - this.CLIENT.getLastAccessedMs();
        if (internalMs > this.MAX_NONE_ACCESS_INTERVAL) {
            this.LOG.debug((Object)("The last Heartbeat was " + internalMs + " ago."));
            this.CLIENT.cleanConnect();
        }
    }
}

