/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class PrefixList {
    private final List<String> LIST;

    public PrefixList(List<String> prefixList) {
        this.LIST = prefixList == null ? new ArrayList<String>(0) : prefixList;
    }

    public PrefixList(String prefixes, String separator) {
        Validate.notNull((Object)separator);
        this.LIST = new ArrayList<String>(0);
        if (prefixes != null && !prefixes.trim().isEmpty()) {
            String[] candidates;
            for (String prefix : candidates = prefixes.trim().split(separator)) {
                String trimmed = prefix.trim();
                if (trimmed.isEmpty()) continue;
                this.LIST.add(trimmed);
            }
        }
    }

    public List<String> getList() {
        return ImmutableList.copyOf(this.LIST);
    }

    public boolean inList(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return false;
        }
        for (int k = 0; k < this.LIST.size(); ++k) {
            if (!path.startsWith(this.LIST.get(k))) continue;
            return true;
        }
        return false;
    }

    public boolean outList(String path) {
        return !this.inList(path);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (String prefix : this.LIST) {
            s.append(prefix).append(";");
        }
        return s.toString();
    }
}

