/*
 * Decompiled with CFR 0.152.
 */
package tachyon.hadoop;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.conf.TachyonConf;

public class ConfUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    private ConfUtils() {
    }

    public static void storeToHadoopConfiguration(TachyonConf source, Configuration target) {
        target.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        Properties confProperties = source.getInternalProperties();
        try {
            DefaultStringifier.store((Configuration)target, (Object)confProperties, (String)"tachyon.conf.site");
        }
        catch (IOException ex) {
            LOG.error("Unable to store TachyonConf in Haddop configuration", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static TachyonConf loadFromHadoopConfiguration(Configuration source) {
        if (source.get("tachyon.conf.site") != null) {
            LOG.info("Found TachyonConf site from Job configuration for Tachyon");
            Properties tachyonConfProperties = null;
            try {
                tachyonConfProperties = (Properties)DefaultStringifier.load((Configuration)source, (String)"tachyon.conf.site", Properties.class);
            }
            catch (IOException e) {
                LOG.error("Unable to load TachyonConf from Haddop configuration", (Throwable)e);
                throw new RuntimeException(e);
            }
            return tachyonConfProperties != null ? new TachyonConf(tachyonConfProperties) : null;
        }
        return null;
    }
}

