/*
 * Decompiled with CFR 0.152.
 */
package tachyon.conf;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.util.CommonUtils;
import tachyon.util.NetworkUtils;

public class TachyonConf {
    public static final String DEFAULT_PROPERTIES = "tachyon-default.properties";
    public static final String SITE_PROPERTIES = "tachyon-site.properties";
    public static final String REGEX_STRING = "(\\$\\{([^{}]*)\\})";
    public static final Pattern CONF_REGEX = Pattern.compile("(\\$\\{([^{}]*)\\})");
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final Properties mProperties = new Properties();

    public static void assertValidPort(int port, TachyonConf tachyonConf) {
        Preconditions.checkArgument((port < 65536 ? 1 : 0) != 0, (Object)"Port must be less than 65536");
        if (!tachyonConf.getBoolean("tachyon.test.mode", false)) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port is only allowed to be zero in test mode.");
        }
    }

    public static void assertValidPort(InetSocketAddress address, TachyonConf tachyonConf) {
        TachyonConf.assertValidPort(address.getPort(), tachyonConf);
    }

    public TachyonConf(TachyonConf tachyonConf) {
        this.merge(tachyonConf);
    }

    public TachyonConf(Map<String, String> props) {
        if (props != null) {
            this.mProperties.putAll(props);
        }
    }

    public TachyonConf(Properties props) {
        if (props != null) {
            this.mProperties.putAll((Map<?, ?>)props);
        }
    }

    public TachyonConf() {
        this(true);
    }

    TachyonConf(boolean includeSystemProperties) {
        Properties defaultProps = new Properties();
        defaultProps.setProperty("tachyon.master.hostname", NetworkUtils.getLocalHostName(250));
        defaultProps.setProperty("tachyon.worker.min.worker.threads", String.valueOf(Runtime.getRuntime().availableProcessors()));
        defaultProps.setProperty("tachyon.master.min.worker.threads", String.valueOf(Runtime.getRuntime().availableProcessors()));
        InputStream defaultInputStream = TachyonConf.class.getClassLoader().getResourceAsStream(DEFAULT_PROPERTIES);
        if (defaultInputStream == null) {
            throw new RuntimeException("The default Tachyon properties file does not exist.");
        }
        try {
            defaultProps.load(defaultInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load default Tachyon properties file.", e);
        }
        Properties siteProps = new Properties();
        InputStream siteInputStream = TachyonConf.class.getClassLoader().getResourceAsStream(SITE_PROPERTIES);
        if (siteInputStream != null) {
            try {
                siteProps.load(siteInputStream);
            }
            catch (IOException e) {
                LOG.warn("Unable to load site Tachyon configuration file.", (Throwable)e);
            }
        }
        Properties systemProps = new Properties();
        if (includeSystemProperties) {
            systemProps.putAll((Map<?, ?>)System.getProperties());
        }
        this.mProperties.putAll((Map<?, ?>)defaultProps);
        this.mProperties.putAll((Map<?, ?>)siteProps);
        this.mProperties.putAll((Map<?, ?>)systemProps);
        String masterHostname = this.mProperties.getProperty("tachyon.master.hostname");
        String masterPort = this.mProperties.getProperty("tachyon.master.port");
        boolean useZk = Boolean.parseBoolean(this.mProperties.getProperty("tachyon.usezookeeper"));
        String masterAddress = (useZk ? "tachyon-ft://" : "tachyon://") + masterHostname + ":" + masterPort;
        this.mProperties.setProperty("tachyon.master.address", masterAddress);
    }

    public int hashCode() {
        int hash = 0;
        for (Object s : this.mProperties.keySet()) {
            hash ^= s.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TachyonConf) {
            Properties props = ((TachyonConf)obj).getInternalProperties();
            return this.mProperties.equals(props);
        }
        return false;
    }

    public Properties getInternalProperties() {
        return (Properties)SerializationUtils.clone((Serializable)this.mProperties);
    }

    public void merge(TachyonConf alternateConf) {
        if (alternateConf != null) {
            this.mProperties.putAll((Map<?, ?>)alternateConf.getInternalProperties());
        }
    }

    public void set(String key, String value) {
        this.mProperties.put(key, value);
    }

    public String get(String key, String defaultValue) {
        String raw = this.mProperties.getProperty(key, defaultValue);
        String updated = this.lookup(raw);
        LOG.debug("Get Tachyon property {} as {} with default {}", new Object[]{key, updated, defaultValue});
        return updated;
    }

    public boolean containsKey(String key) {
        return this.mProperties.containsKey(key);
    }

    public int getInt(String key, int defaultValue) {
        if (this.mProperties.containsKey(key)) {
            String rawValue = this.mProperties.getProperty(key);
            try {
                return Integer.parseInt(this.lookup(rawValue));
            }
            catch (NumberFormatException e) {
                LOG.warn("Configuration cannot evaluate key " + key + " as integer.");
            }
        }
        return defaultValue;
    }

    public long getLong(String key, long defaultValue) {
        if (this.mProperties.containsKey(key)) {
            String rawValue = this.mProperties.getProperty(key);
            try {
                return Long.parseLong(this.lookup(rawValue));
            }
            catch (NumberFormatException e) {
                LOG.warn("Configuration cannot evaluate key " + key + " as long.");
            }
        }
        return defaultValue;
    }

    public double getDouble(String key, double defaultValue) {
        if (this.mProperties.containsKey(key)) {
            String rawValue = this.mProperties.getProperty(key);
            try {
                return Double.parseDouble(this.lookup(rawValue));
            }
            catch (NumberFormatException e) {
                LOG.warn("Configuration cannot evaluate key " + key + " as double.");
            }
        }
        return defaultValue;
    }

    public float getFloat(String key, float defaultValue) {
        if (this.mProperties.containsKey(key)) {
            String rawValue = this.mProperties.getProperty(key);
            try {
                return Float.parseFloat(this.lookup(rawValue));
            }
            catch (NumberFormatException e) {
                LOG.warn("Configuration cannot evaluate key " + key + " as float.");
            }
        }
        return defaultValue;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (this.mProperties.containsKey(key)) {
            String rawValue = this.mProperties.getProperty(key);
            return Boolean.parseBoolean(this.lookup(rawValue));
        }
        return defaultValue;
    }

    public List<String> getList(String key, String delimiter, List<String> defaultValue) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Illegal separator for Tachyon properties as list");
        }
        if (this.mProperties.containsKey(key)) {
            String rawValue = this.mProperties.getProperty(key);
            return Lists.newLinkedList((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)rawValue));
        }
        return defaultValue;
    }

    public <T extends Enum<T>> T getEnum(String key, T defaultValue) {
        if (this.mProperties.containsKey(key)) {
            String val = this.get(key, defaultValue.toString());
            return null == val ? defaultValue : Enum.valueOf(defaultValue.getDeclaringClass(), val);
        }
        return defaultValue;
    }

    public long getBytes(String key, long defaultValue) {
        String rawValue = this.get(key, "");
        try {
            return CommonUtils.parseSpaceSize(rawValue);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public <T> Class<T> getClass(String key, Class<T> defaultValue) {
        if (this.mProperties.containsKey(key)) {
            String rawValue = this.mProperties.getProperty(key);
            try {
                return Class.forName(rawValue);
            }
            catch (Exception e) {
                String msg = "requested class could not be loaded";
                LOG.error("{} : {} , {}", new Object[]{msg, rawValue, e});
            }
        }
        return defaultValue;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> copy = new HashMap<String, String>();
        Enumeration<?> names = this.mProperties.propertyNames();
        while (names.hasMoreElements()) {
            Object key = names.nextElement();
            copy.put(key.toString(), this.mProperties.get(key).toString());
        }
        return copy;
    }

    public String toString() {
        return this.mProperties.toString();
    }

    String lookup(String base) {
        return this.lookup(base, new HashMap<String, String>());
    }

    protected String lookup(String base, Map<String, String> found) {
        if (base == null) {
            return null;
        }
        String resolved = base;
        Matcher matcher = CONF_REGEX.matcher(base);
        while (matcher.find()) {
            String value;
            String match = matcher.group(2).trim();
            if (!found.containsKey(match)) {
                value = this.lookup(this.mProperties.getProperty(match), found);
                found.put(match, value);
            } else {
                value = found.get(match);
            }
            if (value == null) continue;
            LOG.debug("Replacing {} with {}", (Object)matcher.group(1), (Object)value);
            resolved = resolved.replaceFirst(REGEX_STRING, value);
        }
        return resolved;
    }
}

