/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import tachyon.client.BlockInStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFile;
import tachyon.conf.TachyonConf;

public class LocalBlockInStream
extends BlockInStream {
    private TachyonByteBuffer mTachyonBuffer = null;
    private ByteBuffer mBuffer = null;
    private long mBytesReadLocal = 0L;

    LocalBlockInStream(TachyonFile file, ReadType readType, int blockIndex, TachyonByteBuffer buf, TachyonConf tachyonConf) throws IOException {
        super(file, readType, blockIndex, tachyonConf);
        this.mTachyonBuffer = buf;
        this.mBuffer = this.mTachyonBuffer.mData;
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mTachyonBuffer.close();
            if (this.mBytesReadLocal > 0L) {
                this.mTachyonFS.getClientMetrics().incBlocksReadLocal(1L);
            }
        }
        this.mClosed = true;
    }

    @Override
    public int read() throws IOException {
        if (this.mBuffer.remaining() == 0) {
            this.close();
            return -1;
        }
        ++this.mBytesReadLocal;
        this.mTachyonFS.getClientMetrics().incBytesReadLocal(1L);
        return this.mBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int ret = Math.min(len, this.mBuffer.remaining());
        if (ret == 0) {
            this.close();
            return -1;
        }
        this.mBuffer.get(b, off, ret);
        this.mBytesReadLocal += (long)ret;
        this.mTachyonFS.getClientMetrics().incBytesReadLocal(ret);
        return ret;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Seek position is negative: " + pos);
        }
        if (pos > (long)this.mBuffer.limit()) {
            throw new IOException("Seek position is past buffer limit: " + pos + ", Buffer Size = " + this.mBuffer.limit());
        }
        this.mBuffer.position((int)pos);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int ret = this.mBuffer.remaining();
        if ((long)ret > n) {
            ret = (int)n;
        }
        this.mBuffer.position(this.mBuffer.position() + ret);
        return ret;
    }
}

