/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import java.util.HashMap;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.util.CommonUtils;

public class LeaderInquireClient {
    private static final int MAX_TRY = 10;
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static HashMap<String, LeaderInquireClient> sCreatedClients = new HashMap();
    private final String mZookeeperAddress;
    private final String mLeaderPath;
    private final CuratorFramework mCLient;

    public static synchronized LeaderInquireClient getClient(String zookeeperAddress, String leaderPath) {
        String key = zookeeperAddress + leaderPath;
        if (!sCreatedClients.containsKey(key)) {
            sCreatedClients.put(key, new LeaderInquireClient(zookeeperAddress, leaderPath));
        }
        return sCreatedClients.get(key);
    }

    private LeaderInquireClient(String zookeeperAddress, String leaderPath) {
        this.mZookeeperAddress = zookeeperAddress;
        this.mLeaderPath = leaderPath;
        this.mCLient = CuratorFrameworkFactory.newClient((String)this.mZookeeperAddress, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        this.mCLient.start();
    }

    public synchronized String getMasterAddress() {
        int tried = 0;
        try {
            while (tried < 10) {
                if (this.mCLient.checkExists().forPath(this.mLeaderPath) != null) {
                    List masters = (List)this.mCLient.getChildren().forPath(this.mLeaderPath);
                    LOG.info("Master addresses: {}", (Object)masters);
                    if (masters.size() >= 1) {
                        if (masters.size() == 1) {
                            return (String)masters.get(0);
                        }
                        long maxTime = 0L;
                        String leader = "";
                        for (String master : masters) {
                            Stat stat = (Stat)this.mCLient.checkExists().forPath(CommonUtils.concatPath(this.mLeaderPath, master));
                            if (stat == null || stat.getCtime() <= maxTime) continue;
                            maxTime = stat.getCtime();
                            leader = master;
                        }
                        return leader;
                    }
                } else {
                    LOG.info(this.mLeaderPath + " does not exist (" + ++tried + ")");
                }
                CommonUtils.sleepMs(LOG, 1000L);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

