/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro;

import java.io.IOException;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.razorvine.pyro.PyroException;

public class PyroURI
implements Serializable {
    private static final long serialVersionUID = -7611447798373262153L;
    public String protocol = "PYRO";
    public String objectid;
    public String host;
    public int port;

    public PyroURI() {
    }

    public PyroURI(PyroURI pyroURI) {
        this.protocol = pyroURI.protocol;
        this.objectid = pyroURI.objectid;
        this.host = pyroURI.host;
        this.port = pyroURI.port;
    }

    public PyroURI(String string) {
        Pattern pattern = Pattern.compile("(PYRO[A-Z]*):(\\S+?)(@(\\S+))?$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            throw new PyroException("invalid URI string");
        }
        this.protocol = matcher.group(1);
        this.objectid = matcher.group(2);
        String[] stringArray = matcher.group(4).split(":");
        this.host = stringArray[0];
        this.port = Integer.parseInt(stringArray[1]);
    }

    public PyroURI(String string, String string2, int n) {
        this.objectid = string;
        this.host = string2;
        this.port = n;
    }

    public String toString() {
        return "<PyroURI " + this.protocol + ":" + this.objectid + "@" + this.host + ":" + this.port + ">";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof PyroURI)) {
            return false;
        }
        PyroURI pyroURI = (PyroURI)object;
        return this.toString().equals(pyroURI.toString());
    }

    public void __setstate__(Object[] objectArray) throws IOException {
        this.protocol = (String)objectArray[0];
        this.objectid = (String)objectArray[1];
        this.host = (String)objectArray[3];
        this.port = (Integer)objectArray[4];
    }
}

