/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro;

import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Map;
import net.razorvine.pickle.PickleException;
import net.razorvine.pyro.Config;
import net.razorvine.pyro.PyroProxy;
import net.razorvine.pyro.PyroURI;

public class NameServerProxy
extends PyroProxy
implements Serializable {
    private static final long serialVersionUID = -3774989423700492289L;

    public NameServerProxy(PyroURI pyroURI) throws UnknownHostException, IOException {
        this(pyroURI.host, pyroURI.port, pyroURI.objectid);
    }

    public NameServerProxy(String string, int n, String string2) throws UnknownHostException, IOException {
        super(string, n, string2);
    }

    public NameServerProxy(String string, int n) throws IOException {
        this(string, n, "Pyro.NameServer");
    }

    public void ping() throws PickleException, IOException {
        this.call("ping", new Object[0]);
    }

    public PyroURI lookup(String string) throws PickleException, IOException {
        return (PyroURI)this.call("lookup", string);
    }

    public int remove(String string, String string2, String string3) throws PickleException, IOException {
        return (Integer)this.call("remove", string, string2, string3);
    }

    public void register(String string, PyroURI pyroURI, boolean bl) throws PickleException, IOException {
        this.call("register", string, pyroURI, bl);
    }

    public Map<String, String> list(String string, String string2) throws PickleException, IOException {
        return (Map)this.call("list", string, string2);
    }

    public static NameServerProxy locateNS(String string) throws IOException {
        return NameServerProxy.locateNS(string, 0);
    }

    public static NameServerProxy locateNS(String string, int n) throws IOException {
        if (string != null) {
            if (n == 0) {
                n = Config.NS_PORT;
            }
            NameServerProxy nameServerProxy = new NameServerProxy(string, n);
            nameServerProxy.ping();
            return nameServerProxy;
        }
        if (n == 0) {
            n = Config.NS_BCPORT;
        }
        DatagramSocket datagramSocket = new DatagramSocket();
        datagramSocket.setSoTimeout(3000);
        datagramSocket.setBroadcast(true);
        byte[] byArray = "GET_NSURI".getBytes();
        if (string == null) {
            string = "255.255.255.255";
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        datagramSocket.send(datagramPacket);
        DatagramPacket datagramPacket2 = new DatagramPacket(new byte[100], 100);
        try {
            datagramSocket.receive(datagramPacket2);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            if (!string.startsWith("127.0") && !string.equals("localhost")) {
                NameServerProxy nameServerProxy = NameServerProxy.locateNS("localhost", Config.NS_PORT);
                return nameServerProxy;
            }
            throw socketTimeoutException;
        }
        finally {
            datagramSocket.close();
        }
        String string2 = new String(datagramPacket2.getData(), 0, datagramPacket2.getLength());
        return new NameServerProxy(new PyroURI(string2));
    }
}

