/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.razorvine.pickle.IObjectPickler;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.PickleUtils;
import net.razorvine.pickle.objects.Time;
import net.razorvine.pickle.objects.TimeDelta;

public class Pickler {
    public static int HIGHEST_PROTOCOL = 2;
    private static int MAX_RECURSE_DEPTH = 1000;
    private int recurse = 0;
    private OutputStream out;
    private int PROTOCOL = 2;
    private static Map<Class<?>, IObjectPickler> customPicklers = new HashMap();
    private boolean useMemo = true;
    private HashMap<Object, Integer> memo;

    public Pickler() {
        this(true);
    }

    public Pickler(boolean bl) {
        this.useMemo = bl;
    }

    public void close() throws IOException {
        this.memo = null;
        this.out.flush();
        this.out.close();
    }

    public static void registerCustomPickler(Class<?> clazz, IObjectPickler iObjectPickler) {
        customPicklers.put(clazz, iObjectPickler);
    }

    public byte[] dumps(Object object) throws PickleException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.dump(object, byteArrayOutputStream);
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public void dump(Object object, OutputStream outputStream) throws IOException, PickleException {
        this.out = outputStream;
        this.recurse = 0;
        if (this.useMemo) {
            this.memo = new HashMap();
        }
        this.out.write(128);
        this.out.write(this.PROTOCOL);
        this.save(object);
        this.memo = null;
        this.out.write(46);
        this.out.flush();
        if (this.recurse != 0) {
            throw new PickleException("recursive structure error, please report this problem");
        }
    }

    public void save(Object object) throws PickleException, IOException {
        ++this.recurse;
        if (this.recurse > MAX_RECURSE_DEPTH) {
            throw new StackOverflowError("recursion too deep in Pickler.save (>" + MAX_RECURSE_DEPTH + ")");
        }
        if (object == null) {
            this.out.write(78);
            --this.recurse;
            return;
        }
        Class<?> clazz = object.getClass();
        if (this.lookupMemo(clazz, object) || this.dispatch(clazz, object)) {
            --this.recurse;
            return;
        }
        throw new PickleException("couldn't pickle object of type " + clazz);
    }

    private void writeMemo(Object object) throws IOException {
        if (!this.useMemo) {
            return;
        }
        if (!this.memo.containsKey(object)) {
            int n = this.memo.size();
            this.memo.put(object, n);
            if (n <= 255) {
                this.out.write(113);
                this.out.write((byte)n);
            } else {
                this.out.write(114);
                byte[] byArray = PickleUtils.integer_to_bytes(n);
                this.out.write(byArray, 0, 4);
            }
        }
    }

    private boolean lookupMemo(Class<?> clazz, Object object) throws IOException {
        if (!this.useMemo) {
            return false;
        }
        if (!clazz.isPrimitive()) {
            if (!this.memo.containsKey(object)) {
                return false;
            }
            int n = this.memo.get(object);
            if (n <= 255) {
                this.out.write(104);
                this.out.write((byte)n);
            } else {
                this.out.write(106);
                byte[] byArray = PickleUtils.integer_to_bytes(n);
                this.out.write(byArray, 0, 4);
            }
            return true;
        }
        return false;
    }

    private boolean dispatch(Class<?> clazz, Object object) throws IOException {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 != null) {
            if (clazz2.isPrimitive()) {
                this.put_arrayOfPrimitives(clazz2, object);
            } else {
                this.put_arrayOfObjects((Object[])object);
            }
            return true;
        }
        if (object instanceof Boolean || clazz.equals(Boolean.TYPE)) {
            this.put_bool((Boolean)object);
            return true;
        }
        if (object instanceof Byte || clazz.equals(Byte.TYPE)) {
            this.put_long(((Byte)object).longValue());
            return true;
        }
        if (object instanceof Short || clazz.equals(Short.TYPE)) {
            this.put_long(((Short)object).longValue());
            return true;
        }
        if (object instanceof Integer || clazz.equals(Integer.TYPE)) {
            this.put_long(((Integer)object).longValue());
            return true;
        }
        if (object instanceof Long || clazz.equals(Long.TYPE)) {
            this.put_long((Long)object);
            return true;
        }
        if (object instanceof Float || clazz.equals(Float.TYPE)) {
            this.put_float(((Float)object).doubleValue());
            return true;
        }
        if (object instanceof Double || clazz.equals(Double.TYPE)) {
            this.put_float((Double)object);
            return true;
        }
        if (object instanceof Character || clazz.equals(Character.TYPE)) {
            this.put_string("" + object);
            return true;
        }
        IObjectPickler iObjectPickler = customPicklers.get(clazz);
        if (iObjectPickler != null) {
            iObjectPickler.pickle(object, this.out, this);
            this.writeMemo(object);
            return true;
        }
        if (object instanceof String) {
            this.put_string((String)object);
            return true;
        }
        if (object instanceof BigInteger) {
            this.put_bigint((BigInteger)object);
            return true;
        }
        if (object instanceof BigDecimal) {
            this.put_decimal((BigDecimal)object);
            return true;
        }
        if (object instanceof Calendar) {
            this.put_calendar((Calendar)object);
            return true;
        }
        if (object instanceof Time) {
            this.put_time((Time)object);
            return true;
        }
        if (object instanceof TimeDelta) {
            this.put_timedelta((TimeDelta)object);
            return true;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(date);
            this.put_calendar(calendar);
            return true;
        }
        if (object instanceof Enum) {
            this.put_string(object.toString());
            return true;
        }
        if (object instanceof Set) {
            this.put_set((Set)object);
            return true;
        }
        if (object instanceof Map) {
            this.put_map((Map)object);
            return true;
        }
        if (object instanceof List) {
            this.put_collection((List)object);
            return true;
        }
        if (object instanceof Collection) {
            this.put_collection((Collection)object);
            return true;
        }
        if (object instanceof Serializable) {
            this.put_javabean(object);
            return true;
        }
        return false;
    }

    void put_collection(Collection<?> collection) throws IOException {
        this.out.write(93);
        this.writeMemo(collection);
        this.out.write(40);
        for (Object obj : collection) {
            this.save(obj);
        }
        this.out.write(101);
    }

    void put_map(Map<?, ?> map) throws IOException {
        this.out.write(125);
        this.writeMemo(map);
        this.out.write(40);
        for (Object obj : map.keySet()) {
            this.save(obj);
            this.save(map.get(obj));
        }
        this.out.write(117);
    }

    void put_set(Set<?> set) throws IOException {
        this.out.write(99);
        this.out.write("__builtin__\nset\n".getBytes());
        this.out.write(93);
        this.writeMemo(set);
        this.out.write(40);
        for (Object obj : set) {
            this.save(obj);
        }
        this.out.write(101);
        this.out.write(133);
        this.out.write(82);
    }

    void put_calendar(Calendar calendar) throws IOException {
        this.out.write(99);
        this.out.write("datetime\ndatetime\n".getBytes());
        this.out.write(40);
        this.save(calendar.get(1));
        this.save(calendar.get(2) + 1);
        this.save(calendar.get(5));
        this.save(calendar.get(11));
        this.save(calendar.get(12));
        this.save(calendar.get(13));
        this.save(calendar.get(14) * 1000);
        this.out.write(116);
        this.out.write(82);
        this.writeMemo(calendar);
    }

    void put_timedelta(TimeDelta timeDelta) throws IOException {
        this.out.write(99);
        this.out.write("datetime\ntimedelta\n".getBytes());
        this.save(timeDelta.days);
        this.save(timeDelta.seconds);
        this.save(timeDelta.microseconds);
        this.out.write(135);
        this.out.write(82);
        this.writeMemo(timeDelta);
    }

    void put_time(Time time) throws IOException {
        this.out.write(99);
        this.out.write("datetime\ntime\n".getBytes());
        this.out.write(40);
        this.save(time.hours);
        this.save(time.minutes);
        this.save(time.seconds);
        this.save(time.microseconds);
        this.out.write(116);
        this.out.write(82);
        this.writeMemo(time);
    }

    void put_arrayOfObjects(Object[] objectArray) throws IOException {
        if (objectArray.length == 0) {
            this.out.write(41);
        } else if (objectArray.length == 1) {
            if (objectArray[0] == objectArray) {
                throw new PickleException("recursive array not supported, use list");
            }
            this.save(objectArray[0]);
            this.out.write(133);
        } else if (objectArray.length == 2) {
            if (objectArray[0] == objectArray || objectArray[1] == objectArray) {
                throw new PickleException("recursive array not supported, use list");
            }
            this.save(objectArray[0]);
            this.save(objectArray[1]);
            this.out.write(134);
        } else if (objectArray.length == 3) {
            if (objectArray[0] == objectArray || objectArray[1] == objectArray || objectArray[2] == objectArray) {
                throw new PickleException("recursive array not supported, use list");
            }
            this.save(objectArray[0]);
            this.save(objectArray[1]);
            this.save(objectArray[2]);
            this.out.write(135);
        } else {
            this.out.write(40);
            for (Object object : objectArray) {
                if (object == objectArray) {
                    throw new PickleException("recursive array not supported, use list");
                }
                this.save(object);
            }
            this.out.write(116);
        }
        this.writeMemo(objectArray);
    }

    void put_arrayOfPrimitives(Class<?> clazz, Object object) throws IOException {
        if (clazz.equals(Boolean.TYPE)) {
            boolean[] blArray = (boolean[])object;
            Object[] objectArray = new Boolean[blArray.length];
            for (int i = 0; i < blArray.length; ++i) {
                objectArray[i] = blArray[i];
            }
            this.put_arrayOfObjects(objectArray);
            return;
        }
        if (clazz.equals(Character.TYPE)) {
            String string = new String((char[])object);
            this.put_string(string);
            return;
        }
        if (clazz.equals(Byte.TYPE)) {
            this.out.write(99);
            this.out.write("__builtin__\nbytearray\n".getBytes());
            String string = PickleUtils.rawStringFromBytes((byte[])object);
            this.put_string(string);
            this.put_string("latin-1");
            this.out.write(134);
            this.out.write(82);
            this.writeMemo(object);
            return;
        }
        this.out.write(99);
        this.out.write("array\narray\n".getBytes());
        this.out.write(85);
        this.out.write(1);
        if (clazz.equals(Short.TYPE)) {
            this.out.write(104);
            this.out.write(93);
            this.out.write(40);
            for (short s : (short[])object) {
                this.save(s);
            }
        } else if (clazz.equals(Integer.TYPE)) {
            this.out.write(105);
            this.out.write(93);
            this.out.write(40);
            for (int n : (int[])object) {
                this.save(n);
            }
        } else if (clazz.equals(Long.TYPE)) {
            this.out.write(108);
            this.out.write(93);
            this.out.write(40);
            for (long l : (long[])object) {
                this.save(l);
            }
        } else if (clazz.equals(Float.TYPE)) {
            this.out.write(102);
            this.out.write(93);
            this.out.write(40);
            for (float f : (float[])object) {
                this.save(Float.valueOf(f));
            }
        } else if (clazz.equals(Double.TYPE)) {
            this.out.write(100);
            this.out.write(93);
            this.out.write(40);
            for (double d : (double[])object) {
                this.save(d);
            }
        }
        this.out.write(101);
        this.out.write(134);
        this.out.write(82);
        this.writeMemo(object);
    }

    void put_decimal(BigDecimal bigDecimal) throws IOException {
        this.out.write(99);
        this.out.write("decimal\nDecimal\n".getBytes());
        this.put_string(bigDecimal.toEngineeringString());
        this.out.write(133);
        this.out.write(82);
        this.writeMemo(bigDecimal);
    }

    void put_bigint(BigInteger bigInteger) throws IOException {
        byte[] byArray = PickleUtils.encode_long(bigInteger);
        if (byArray.length <= 255) {
            this.out.write(138);
            this.out.write(byArray.length);
            this.out.write(byArray);
        } else {
            this.out.write(139);
            this.out.write(PickleUtils.integer_to_bytes(byArray.length));
            this.out.write(byArray);
        }
    }

    void put_string(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        this.out.write(88);
        this.out.write(PickleUtils.integer_to_bytes(byArray.length));
        this.out.write(byArray);
        this.writeMemo(string);
    }

    void put_float(double d) throws IOException {
        this.out.write(71);
        this.out.write(PickleUtils.double_to_bytes(d));
    }

    void put_long(long l) throws IOException {
        long l2;
        if (l >= 0L) {
            if (l <= 255L) {
                this.out.write(75);
                this.out.write((int)l);
                return;
            }
            if (l <= 65535L) {
                this.out.write(77);
                this.out.write((int)l & 0xFF);
                this.out.write((int)l >> 8);
                return;
            }
        }
        if ((l2 = l >> 31) == 0L || l2 == -1L) {
            this.out.write(74);
            this.out.write(PickleUtils.integer_to_bytes((int)l));
            return;
        }
        this.out.write(73);
        this.out.write(("" + l).getBytes());
        this.out.write(10);
    }

    void put_bool(boolean bl) throws IOException {
        if (bl) {
            this.out.write(136);
        } else {
            this.out.write(137);
        }
    }

    void put_javabean(Object object) throws PickleException, IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            for (Method method : object.getClass().getMethods()) {
                int n = method.getModifiers();
                if ((n & 1) == 0 || (n & 8) != 0) continue;
                String string = method.getName();
                int n2 = 0;
                if (string.equals("getClass")) continue;
                if (string.startsWith("get")) {
                    n2 = 3;
                } else {
                    if (!string.startsWith("is")) continue;
                    n2 = 2;
                }
                Object object2 = method.invoke(object, new Object[0]);
                String string2 = string.substring(n2);
                if (string2.length() == 1) {
                    string2 = string2.toLowerCase();
                } else if (!Character.isUpperCase(string2.charAt(1))) {
                    string2 = Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
                }
                hashMap.put(string2, object2);
            }
            hashMap.put("__class__", object.getClass().getName());
            this.save(hashMap);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PickleException("couldn't introspect javabean: " + illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PickleException("couldn't introspect javabean: " + illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PickleException("couldn't introspect javabean: " + invocationTargetException);
        }
    }
}

