/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.support;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtil {
    public static <T> Class<T> loadClass(Class<T> type, ClassLoader classloader) {
        return ClassLoaderUtil.loadClass(type.getName(), classloader);
    }

    public static <T> Class<T> loadClass(String className) {
        return ClassLoaderUtil.loadClass(className, ClassLoaderUtil.class.getClassLoader());
    }

    public static <T> Class<T> loadClass(String className, ClassLoader classloader) {
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null");
        }
        if (classloader == null) {
            throw new IllegalArgumentException("classloader cannot be null");
        }
        try {
            return Class.forName(className, false, classloader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

