/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.DoesNothing;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.expectation.ConstructorExpectationSetup;
import org.powermock.api.mockito.expectation.PowerMockitoStubber;
import org.powermock.api.mockito.expectation.WithOrWithoutExpectedArguments;
import org.powermock.api.mockito.internal.PowerMockitoCore;
import org.powermock.api.mockito.internal.expectation.ConstructorAwareExpectationSetup;
import org.powermock.api.mockito.internal.expectation.DefaultConstructorExpectationSetup;
import org.powermock.api.mockito.internal.expectation.DefaultMethodExpectationSetup;
import org.powermock.api.mockito.internal.mockcreation.MockCreator;
import org.powermock.api.mockito.internal.verification.DefaultConstructorArgumentsVerfication;
import org.powermock.api.mockito.internal.verification.DefaultPrivateMethodVerification;
import org.powermock.api.mockito.internal.verification.VerifyNoMoreInteractions;
import org.powermock.api.mockito.verification.ConstructorArgumentsVerification;
import org.powermock.api.mockito.verification.PrivateMethodVerification;
import org.powermock.api.support.membermodification.MemberModifier;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.reflect.Whitebox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerMockito
extends MemberModifier {
    private static final String NO_OBJECT_CREATION_ERROR_MESSAGE_TEMPLATE = "No instantiation of class %s was recorded during the test. Note that only expected object creations (e.g. those using whenNew(..)) can be verified.";
    private static final PowerMockitoCore POWERMOCKITO_CORE = new PowerMockitoCore();

    public static synchronized void mockStatic(Class<?> type, Class<?> ... types) {
        MockCreator.mock(type, true, false, null, null, null);
        if (types != null && types.length > 0) {
            for (Class<?> aClass : types) {
                MockCreator.mock(aClass, true, false, null, null, null);
            }
        }
    }

    public static void mockStatic(Class<?> classMock, Answer defaultAnswer) {
        PowerMockito.mockStatic(classMock, Mockito.withSettings().defaultAnswer(defaultAnswer));
    }

    public static void mockStatic(Class<?> classToMock, MockSettings mockSettings) {
        MockCreator.mock(classToMock, true, false, null, mockSettings, null);
    }

    public static synchronized <T> T mock(Class<T> type) {
        return MockCreator.mock(type, false, false, null, null, null);
    }

    public static <T> T mock(Class<T> classToMock, Answer defaultAnswer) {
        return PowerMockito.mock(classToMock, Mockito.withSettings().defaultAnswer(defaultAnswer));
    }

    public static <T> T mock(Class<T> classToMock, MockSettings mockSettings) {
        return MockCreator.mock(classToMock, false, false, null, mockSettings, null);
    }

    public static synchronized <T> T spy(T object) {
        return MockCreator.mock(Whitebox.getType(object), false, true, object, null, null);
    }

    public static synchronized <T> void spy(Class<T> type) {
        MockCreator.mock(type, true, true, type, null, null);
    }

    public static synchronized void verifyStatic() {
        PowerMockito.verifyStatic(Mockito.times((int)1));
    }

    public static synchronized void verifyStatic(VerificationMode verificationMode) {
        ((MockingProgress)Whitebox.getInternalState(Mockito.class, MockingProgress.class)).verificationStarted((VerificationMode)POWERMOCKITO_CORE.wrapInStaticVerificationMode(verificationMode));
    }

    public static PrivateMethodVerification verifyPrivate(Object object) throws Exception {
        return PowerMockito.verifyPrivate(object, Mockito.times((int)1));
    }

    public static PrivateMethodVerification verifyPrivate(Object object, VerificationMode verificationMode) throws Exception {
        ((MockingProgress)Whitebox.getInternalState(Mockito.class, MockingProgress.class)).verificationStarted((VerificationMode)POWERMOCKITO_CORE.wrapInMockitoSpecificVerificationMode(object, verificationMode));
        return new DefaultPrivateMethodVerification(object);
    }

    public static PrivateMethodVerification verifyPrivate(Class<?> clazz) throws Exception {
        return PowerMockito.verifyPrivate(clazz);
    }

    public static PrivateMethodVerification verifyPrivate(Class<?> clazz, VerificationMode verificationMode) throws Exception {
        return PowerMockito.verifyPrivate(clazz, verificationMode);
    }

    public static synchronized <T> ConstructorArgumentsVerification verifyNew(Class<T> mock) {
        if (mock == null) {
            throw new IllegalArgumentException("Class to verify cannot be null");
        }
        NewInvocationControl invocationControl = MockRepository.getNewInstanceControl(mock);
        if (invocationControl == null) {
            throw new IllegalStateException(String.format(NO_OBJECT_CREATION_ERROR_MESSAGE_TEMPLATE, Whitebox.getType(mock).getName()));
        }
        invocationControl.verify(new Object[0]);
        return new DefaultConstructorArgumentsVerfication(invocationControl, mock);
    }

    public static <T> ConstructorArgumentsVerification verifyNew(Class<?> mock, VerificationMode mode) {
        if (mock == null) {
            throw new IllegalArgumentException("Class to verify cannot be null");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Verify mode cannot be null");
        }
        NewInvocationControl invocationControl = MockRepository.getNewInstanceControl(mock);
        MockRepository.putAdditionalState((String)"VerificationMode", (Object)POWERMOCKITO_CORE.wrapInMockitoSpecificVerificationMode(mock, mode));
        if (invocationControl == null) {
            throw new IllegalStateException(String.format(NO_OBJECT_CREATION_ERROR_MESSAGE_TEMPLATE, Whitebox.getType(mock).getName()));
        }
        try {
            invocationControl.verify(new Object[0]);
        }
        finally {
            MockRepository.removeAdditionalState((String)"VerificationMode");
        }
        return new DefaultConstructorArgumentsVerfication(invocationControl, mock);
    }

    public static <T> OngoingStubbing<T> when(Object instance, String methodName, Object ... arguments) throws Exception {
        return Mockito.when((Object)Whitebox.invokeMethod((Object)instance, (String)methodName, (Object[])arguments));
    }

    public static <T> WithOrWithoutExpectedArguments<T> when(Object instance, Method method) throws Exception {
        return new DefaultMethodExpectationSetup(instance, method);
    }

    public static <T> WithOrWithoutExpectedArguments<T> when(Class<?> cls, Method method) throws Exception {
        return new DefaultMethodExpectationSetup(cls, method);
    }

    public static <T> OngoingStubbing<T> when(Object instance, Object ... arguments) throws Exception {
        return Mockito.when((Object)Whitebox.invokeMethod((Object)instance, (Object[])arguments));
    }

    public static <T> OngoingStubbing<T> when(Class<?> clazz, String methodToExpect, Object ... arguments) throws Exception {
        return Mockito.when((Object)Whitebox.invokeMethod(clazz, (String)methodToExpect, (Object[])arguments));
    }

    public static <T> OngoingStubbing<T> when(Class<?> klass, Object ... arguments) throws Exception {
        return Mockito.when((Object)Whitebox.invokeMethod(klass, (Object[])arguments));
    }

    public static <T> OngoingStubbing<T> when(T methodCall) {
        return Mockito.when(methodCall);
    }

    public static synchronized <T> WithOrWithoutExpectedArguments<T> whenNew(Constructor<T> ctor) {
        return new ConstructorAwareExpectationSetup<T>(ctor);
    }

    public static synchronized <T> ConstructorExpectationSetup<T> whenNew(Class<T> type) {
        return new DefaultConstructorExpectationSetup<T>(type);
    }

    public static synchronized <T> ConstructorExpectationSetup<T> whenNew(String fullyQualifiedName) throws Exception {
        Class<?> forName = Class.forName(fullyQualifiedName);
        return new DefaultConstructorExpectationSetup(forName);
    }

    public static void verifyNoMoreInteractions(Object ... mocks) {
        VerifyNoMoreInteractions.verifyNoMoreInteractions(mocks);
    }

    public static void verifyZeroInteractions(Object ... mocks) {
        VerifyNoMoreInteractions.verifyNoMoreInteractions(mocks);
    }

    public static PowerMockitoStubber doAnswer(Answer<?> answer) {
        return POWERMOCKITO_CORE.doAnswer(answer);
    }

    public static PowerMockitoStubber doThrow(Throwable toBeThrown) {
        return POWERMOCKITO_CORE.doAnswer((Answer)new ThrowsException(toBeThrown));
    }

    public static PowerMockitoStubber doCallRealMethod() {
        return POWERMOCKITO_CORE.doAnswer((Answer)new CallsRealMethods());
    }

    public static PowerMockitoStubber doNothing() {
        return POWERMOCKITO_CORE.doAnswer((Answer)new DoesNothing());
    }

    public static PowerMockitoStubber doReturn(Object toBeReturned) {
        return POWERMOCKITO_CORE.doAnswer((Answer)new Returns(toBeReturned));
    }
}

