/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.hive;

import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.spi.MetadataProvider;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;
import org.kitesdk.data.spi.hive.HiveAbstractMetadataProvider;
import org.kitesdk.shaded.com.google.common.annotations.VisibleForTesting;
import org.kitesdk.shaded.com.google.common.base.Preconditions;

class HiveAbstractDatasetRepository
extends FileSystemDatasetRepository {
    private final MetadataProvider provider;
    private final URI repoUri;

    HiveAbstractDatasetRepository(Configuration conf, Path rootDirectory, MetadataProvider provider) {
        super(conf, rootDirectory, provider);
        this.provider = provider;
        this.repoUri = this.getRepositoryUri(conf, rootDirectory);
    }

    HiveAbstractDatasetRepository(Configuration conf, MetadataProvider provider) {
        super(conf, new Path("/tmp"), provider);
        this.provider = provider;
        this.repoUri = this.getRepositoryUri(conf, null);
    }

    public boolean delete(String namespace, String name) {
        try {
            if (this.isManaged(namespace, name)) {
                return this.getMetadataProvider().delete(namespace, name);
            }
            return super.delete(namespace, name);
        }
        catch (DatasetNotFoundException e) {
            return false;
        }
    }

    public URI getUri() {
        return this.repoUri;
    }

    @VisibleForTesting
    MetadataProvider getMetadataProvider() {
        return this.provider;
    }

    private boolean isManaged(String namespace, String name) {
        MetadataProvider provider = this.getMetadataProvider();
        if (provider instanceof HiveAbstractMetadataProvider) {
            return ((HiveAbstractMetadataProvider)provider).isManaged(namespace, name);
        }
        return false;
    }

    private URI getRepositoryUri(Configuration conf, @Nullable Path rootDirectory) {
        String hiveMetaStoreUriProperty = conf.get("hive.metastore.uris");
        StringBuilder uri = new StringBuilder("repo:hive");
        if (hiveMetaStoreUriProperty != null) {
            URI hiveMetaStoreUri = URI.create(hiveMetaStoreUriProperty);
            Preconditions.checkArgument(hiveMetaStoreUri.getScheme().equals("thrift"), "Metastore URI scheme must be 'thrift'.");
            uri.append("://").append(hiveMetaStoreUri.getAuthority());
        }
        if (rootDirectory != null) {
            if (hiveMetaStoreUriProperty == null) {
                uri.append(":");
            }
            URI rootUri = rootDirectory.toUri();
            uri.append(rootUri.getPath());
            if (rootUri.getHost() != null) {
                uri.append("?").append("hdfs:host").append("=").append(rootUri.getHost());
                if (rootUri.getPort() != -1) {
                    uri.append("&").append("hdfs:port").append("=").append(rootUri.getPort());
                }
            }
        }
        return URI.create(uri.toString());
    }
}

