/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.shaded.com.google.common.eventbus;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.kitesdk.shaded.com.google.common.annotations.Beta;
import org.kitesdk.shaded.com.google.common.eventbus.EventBus;
import org.kitesdk.shaded.com.google.common.eventbus.EventHandler;

@Beta
public class AsyncEventBus
extends EventBus {
    private final Executor executor;
    private final ConcurrentLinkedQueue<EventBus.EventWithHandler> eventsToDispatch = new ConcurrentLinkedQueue();

    public AsyncEventBus(String identifier, Executor executor) {
        super(identifier);
        this.executor = executor;
    }

    public AsyncEventBus(Executor executor) {
        this.executor = executor;
    }

    protected void enqueueEvent(Object event, EventHandler handler) {
        this.eventsToDispatch.offer(new EventBus.EventWithHandler(event, handler));
    }

    protected void dispatchQueuedEvents() {
        EventBus.EventWithHandler eventWithHandler;
        while ((eventWithHandler = this.eventsToDispatch.poll()) != null) {
            this.dispatch(eventWithHandler.event, eventWithHandler.handler);
        }
    }

    protected void dispatch(final Object event, final EventHandler handler) {
        this.executor.execute(new Runnable(){

            public void run() {
                AsyncEventBus.super.dispatch(event, handler);
            }
        });
    }
}

