/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.hive;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.thrift.TException;
import org.kitesdk.data.DatasetExistsException;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.DatasetOperationException;
import org.kitesdk.shaded.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreUtil.class);
    private static final String ALLOW_LOCAL_METASTORE = "kite.hive.allow-local-metastore";
    private final HiveMetaStoreClient client;
    private final HiveConf hiveConf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R doWithRetry(ClientAction<R> action) throws TException {
        try {
            HiveMetaStoreClient hiveMetaStoreClient = this.client;
            synchronized (hiveMetaStoreClient) {
                return action.call();
            }
        }
        catch (TException e) {
            HiveMetaStoreClient hiveMetaStoreClient;
            try {
                hiveMetaStoreClient = this.client;
                synchronized (hiveMetaStoreClient) {
                    this.client.reconnect();
                }
            }
            catch (MetaException swallowedException) {
                throw e;
            }
            hiveMetaStoreClient = this.client;
            synchronized (hiveMetaStoreClient) {
                return action.call();
            }
        }
    }

    public MetaStoreUtil(Configuration conf) {
        this.hiveConf = new HiveConf(conf, HiveConf.class);
        if (!this.allowLocalMetaStore(this.hiveConf) && this.isEmpty(this.hiveConf, "hive.metastore.uris")) {
            LOG.warn("Aborting use of local MetaStore. Allow local MetaStore by setting {}=true in HiveConf", (Object)ALLOW_LOCAL_METASTORE);
            throw new IllegalArgumentException("Missing Hive MetaStore connection URI");
        }
        try {
            this.client = new HiveMetaStoreClient(this.hiveConf);
        }
        catch (TException e) {
            throw new DatasetOperationException("Hive metastore exception", (Throwable)e);
        }
    }

    private boolean allowLocalMetaStore(HiveConf conf) {
        return conf.getBoolean(ALLOW_LOCAL_METASTORE, false);
    }

    private boolean isEmpty(HiveConf conf, String prop) {
        String value = conf.get(prop);
        return value == null || value.isEmpty();
    }

    public Table getTable(final String dbName, final String tableName) {
        Table table;
        ClientAction<Table> getTable = new ClientAction<Table>(){

            @Override
            public Table call() throws TException {
                return new Table(MetaStoreUtil.this.client.getTable(dbName, tableName));
            }
        };
        try {
            table = this.doWithRetry(getTable);
        }
        catch (NoSuchObjectException e) {
            throw new DatasetNotFoundException("Hive table not found: " + dbName + "." + tableName);
        }
        catch (MetaException e) {
            throw new DatasetNotFoundException("Hive table lookup exception", (Throwable)e);
        }
        catch (TException e) {
            throw new DatasetOperationException("Exception communicating with the Hive MetaStore", (Throwable)e);
        }
        if (table == null) {
            throw new DatasetNotFoundException("Could not find info for table: " + tableName);
        }
        return table;
    }

    public boolean tableExists(final String dbName, final String tableName) {
        ClientAction<Boolean> exists = new ClientAction<Boolean>(){

            @Override
            public Boolean call() throws TException {
                return MetaStoreUtil.this.client.tableExists(dbName, tableName);
            }
        };
        try {
            return this.doWithRetry(exists);
        }
        catch (UnknownDBException e) {
            return false;
        }
        catch (MetaException e) {
            throw new DatasetOperationException("Hive MetaStore exception", (Throwable)e);
        }
        catch (TException e) {
            throw new DatasetOperationException("Exception communicating with the Hive MetaStore", (Throwable)e);
        }
    }

    public void createDatabase(final String dbName) {
        ClientAction<Void> create = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                MetaStoreUtil.this.client.createDatabase(new Database(dbName, "Database created by Kite", null, null));
                return null;
            }
        };
        try {
            this.doWithRetry(create);
        }
        catch (AlreadyExistsException e) {
            throw new DatasetExistsException("Hive database already exists: " + dbName, (Throwable)e);
        }
        catch (InvalidObjectException e) {
            throw new DatasetOperationException("Invalid database: " + dbName, (Throwable)e);
        }
        catch (MetaException e) {
            throw new DatasetOperationException("Hive MetaStore exception", (Throwable)e);
        }
        catch (TException e) {
            throw new DatasetOperationException("Exception communicating with the Hive MetaStore", (Throwable)e);
        }
    }

    public void createTable(final Table tbl) {
        ClientAction<Void> create = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                MetaStoreUtil.this.client.createTable(tbl);
                return null;
            }
        };
        try {
            this.createDatabase(tbl.getDbName());
        }
        catch (DatasetExistsException e) {
            // empty catch block
        }
        try {
            this.doWithRetry(create);
        }
        catch (NoSuchObjectException e) {
            throw new DatasetNotFoundException("Hive table not found: " + tbl.getDbName() + "." + tbl.getTableName());
        }
        catch (AlreadyExistsException e) {
            throw new DatasetExistsException("Hive table already exists: " + tbl.getDbName() + "." + tbl.getTableName(), (Throwable)e);
        }
        catch (InvalidObjectException e) {
            throw new DatasetOperationException("Invalid table", (Throwable)e);
        }
        catch (MetaException e) {
            throw new DatasetOperationException("Hive MetaStore exception", (Throwable)e);
        }
        catch (TException e) {
            throw new DatasetOperationException("Exception communicating with the Hive MetaStore", (Throwable)e);
        }
    }

    public void alterTable(final Table tbl) {
        ClientAction<Void> alter = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                MetaStoreUtil.this.client.alter_table(tbl.getDbName(), tbl.getTableName(), tbl);
                return null;
            }
        };
        try {
            this.doWithRetry(alter);
        }
        catch (NoSuchObjectException e) {
            throw new DatasetNotFoundException("Hive table not found: " + tbl.getDbName() + "." + tbl.getTableName());
        }
        catch (InvalidObjectException e) {
            throw new DatasetOperationException("Invalid table", (Throwable)e);
        }
        catch (InvalidOperationException e) {
            throw new DatasetOperationException("Invalid table change", (Throwable)e);
        }
        catch (MetaException e) {
            throw new DatasetOperationException("Hive MetaStore exception", (Throwable)e);
        }
        catch (TException e) {
            throw new DatasetOperationException("Exception communicating with the Hive MetaStore", (Throwable)e);
        }
    }

    public void dropTable(final String dbName, final String tableName) {
        ClientAction<Void> drop = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                MetaStoreUtil.this.client.dropTable(dbName, tableName, true, true);
                return null;
            }
        };
        try {
            this.doWithRetry(drop);
        }
        catch (NoSuchObjectException e) {
        }
        catch (MetaException e) {
            throw new DatasetOperationException("Hive MetaStore exception", (Throwable)e);
        }
        catch (TException e) {
            throw new DatasetOperationException("Exception communicating with the Hive MetaStore", (Throwable)e);
        }
    }

    public void addPartition(final String dbName, final String tableName, final String path) {
        ClientAction<Void> addPartition = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                MetaStoreUtil.this.client.appendPartition(dbName, tableName, path);
                return null;
            }
        };
        try {
            this.doWithRetry(addPartition);
        }
        catch (AlreadyExistsException e) {
        }
        catch (InvalidObjectException e) {
            throw new DatasetOperationException("Invalid partition for " + dbName + "." + tableName + ": " + path, (Throwable)e);
        }
        catch (MetaException e) {
            throw new DatasetOperationException("Hive MetaStore exception", (Throwable)e);
        }
        catch (TException e) {
            throw new DatasetOperationException("Exception communicating with the Hive MetaStore", (Throwable)e);
        }
    }

    public void dropPartition(final String dbName, final String tableName, final String path) {
        ClientAction<Void> dropPartition = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                MetaStoreUtil.this.client.dropPartition(dbName, tableName, path, false);
                return null;
            }
        };
        try {
            this.doWithRetry(dropPartition);
        }
        catch (NoSuchObjectException e) {
        }
        catch (InvalidObjectException e) {
            throw new DatasetOperationException("Invalid partition for " + dbName + "." + tableName + ": " + path, (Throwable)e);
        }
        catch (MetaException e) {
            throw new DatasetOperationException("Hive MetaStore exception", (Throwable)e);
        }
        catch (TException e) {
            throw new DatasetOperationException("Exception communicating with the Hive MetaStore", (Throwable)e);
        }
    }

    public boolean exists(String dbName, String tableName) {
        return this.tableExists(dbName, tableName);
    }

    public List<String> getAllTables(final String dbName) {
        ClientAction<List<String>> create = new ClientAction<List<String>>(){

            @Override
            public List<String> call() throws TException {
                return MetaStoreUtil.this.client.getAllTables(dbName);
            }
        };
        try {
            return this.doWithRetry(create);
        }
        catch (NoSuchObjectException e) {
            return ImmutableList.of();
        }
        catch (MetaException e) {
            throw new DatasetOperationException("Hive MetaStore exception", (Throwable)e);
        }
        catch (TException e) {
            throw new DatasetOperationException("Exception communicating with the Hive MetaStore", (Throwable)e);
        }
    }

    public List<String> getAllDatabases() {
        ClientAction<List<String>> create = new ClientAction<List<String>>(){

            @Override
            public List<String> call() throws TException {
                return MetaStoreUtil.this.client.getAllDatabases();
            }
        };
        try {
            return this.doWithRetry(create);
        }
        catch (NoSuchObjectException e) {
            return ImmutableList.of();
        }
        catch (MetaException e) {
            throw new DatasetOperationException("Hive MetaStore exception", (Throwable)e);
        }
        catch (TException e) {
            throw new DatasetOperationException("Exception communicating with the Hive MetaStore", (Throwable)e);
        }
    }

    public void dropDatabase(final String name, final boolean deleteData) {
        ClientAction<Void> drop = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                MetaStoreUtil.this.client.dropDatabase(name, deleteData, true);
                return null;
            }
        };
        try {
            this.doWithRetry(drop);
        }
        catch (NoSuchObjectException e) {
        }
        catch (MetaException e) {
            throw new DatasetOperationException("Hive MetaStore exception", (Throwable)e);
        }
        catch (TException e) {
            throw new DatasetOperationException("Exception communicating with the Hive MetaStore", (Throwable)e);
        }
    }

    private static interface ClientAction<R> {
        public R call() throws TException;
    }
}

