/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.CompareFunctionType;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="KNNInput", namespace="http://www.dmg.org/PMML-4_2")
@Added(value=Version.PMML_4_1)
public class KNNInput
extends ComparisonField
implements HasExtensions {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    protected FieldName field;
    @XmlAttribute(name="fieldWeight")
    protected Double fieldWeight;
    @XmlAttribute(name="compareFunction")
    protected CompareFunctionType compareFunction;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;

    public KNNInput() {
    }

    public KNNInput(FieldName field) {
        this.field = field;
    }

    @Override
    public FieldName getField() {
        return this.field;
    }

    @Override
    public void setField(FieldName value) {
        this.field = value;
    }

    @Override
    public double getFieldWeight() {
        if (this.fieldWeight == null) {
            return 1.0;
        }
        return this.fieldWeight;
    }

    @Override
    public void setFieldWeight(Double value) {
        this.fieldWeight = value;
    }

    @Override
    public CompareFunctionType getCompareFunction() {
        return this.compareFunction;
    }

    @Override
    public void setCompareFunction(CompareFunctionType value) {
        this.compareFunction = value;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public KNNInput withField(FieldName value) {
        this.setField(value);
        return this;
    }

    public KNNInput withFieldWeight(Double value) {
        this.setFieldWeight(value);
        return this;
    }

    public KNNInput withCompareFunction(CompareFunctionType value) {
        this.setCompareFunction(value);
        return this;
    }

    public KNNInput withExtensions(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtensions().add(value);
            }
        }
        return this;
    }

    public KNNInput withExtensions(Collection<Extension> values) {
        if (values != null) {
            this.getExtensions().addAll(values);
        }
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public Double getSimilarityScale() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSimilarityScale(Double similarityScale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; status == VisitorAction.CONTINUE && this.extensions != null && i < this.extensions.size(); ++i) {
            status = this.extensions.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

