/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldValueCount;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "fieldValues", "fieldValueCounts"})
@XmlRootElement(name="FieldValue", namespace="http://www.dmg.org/PMML-4_2")
@Added(value=Version.PMML_4_1)
public class FieldValue
extends PMMLObject
implements HasExtensions {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    protected FieldName field;
    @XmlAttribute(name="value", required=true)
    @XmlSchemaType(name="anySimpleType")
    protected String value;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name="FieldValue", namespace="http://www.dmg.org/PMML-4_2")
    protected List<FieldValue> fieldValues;
    @XmlElement(name="FieldValueCount", namespace="http://www.dmg.org/PMML-4_2")
    protected List<FieldValueCount> fieldValueCounts;

    public FieldValue() {
    }

    public FieldValue(FieldName field, String value) {
        this.field = field;
        this.value = value;
    }

    public FieldName getField() {
        return this.field;
    }

    public void setField(FieldName value) {
        this.field = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<FieldValue> getFieldValues() {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldValue>();
        }
        return this.fieldValues;
    }

    public List<FieldValueCount> getFieldValueCounts() {
        if (this.fieldValueCounts == null) {
            this.fieldValueCounts = new ArrayList<FieldValueCount>();
        }
        return this.fieldValueCounts;
    }

    public FieldValue withField(FieldName value) {
        this.setField(value);
        return this;
    }

    public FieldValue withValue(String value) {
        this.setValue(value);
        return this;
    }

    public FieldValue withExtensions(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtensions().add(value);
            }
        }
        return this;
    }

    public FieldValue withExtensions(Collection<Extension> values) {
        if (values != null) {
            this.getExtensions().addAll(values);
        }
        return this;
    }

    public FieldValue withFieldValues(FieldValue ... values) {
        if (values != null) {
            for (FieldValue value : values) {
                this.getFieldValues().add(value);
            }
        }
        return this;
    }

    public FieldValue withFieldValues(Collection<FieldValue> values) {
        if (values != null) {
            this.getFieldValues().addAll(values);
        }
        return this;
    }

    public FieldValue withFieldValueCounts(FieldValueCount ... values) {
        if (values != null) {
            for (FieldValueCount value : values) {
                this.getFieldValueCounts().add(value);
            }
        }
        return this;
    }

    public FieldValue withFieldValueCounts(Collection<FieldValueCount> values) {
        if (values != null) {
            this.getFieldValueCounts().addAll(values);
        }
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public boolean hasFieldValues() {
        return this.fieldValues != null && this.fieldValues.size() > 0;
    }

    public boolean hasFieldValueCounts() {
        return this.fieldValueCounts != null && this.fieldValueCounts.size() > 0;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        int i;
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (i = 0; status == VisitorAction.CONTINUE && this.extensions != null && i < this.extensions.size(); ++i) {
            status = this.extensions.get(i).accept(visitor);
        }
        for (i = 0; status == VisitorAction.CONTINUE && this.fieldValues != null && i < this.fieldValues.size(); ++i) {
            status = this.fieldValues.get(i).accept(visitor);
        }
        for (i = 0; status == VisitorAction.CONTINUE && this.fieldValueCounts != null && i < this.fieldValueCounts.size(); ++i) {
            status = this.fieldValueCounts.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

