/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.Chebychev;
import org.dmg.pmml.CityBlock;
import org.dmg.pmml.CompareFunctionType;
import org.dmg.pmml.Euclidean;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.Measure;
import org.dmg.pmml.Minkowski;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.Tanimoto;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "measure"})
@XmlRootElement(name="ComparisonMeasure", namespace="http://www.dmg.org/PMML-4_2")
public class ComparisonMeasure
extends PMMLObject
implements HasExtensions {
    @XmlAttribute(name="kind", required=true)
    protected Kind kind;
    @XmlAttribute(name="compareFunction")
    protected CompareFunctionType compareFunction;
    @XmlAttribute(name="minimum")
    protected Double minimum;
    @XmlAttribute(name="maximum")
    protected Double maximum;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElements(value={@XmlElement(name="euclidean", namespace="http://www.dmg.org/PMML-4_2", type=Euclidean.class), @XmlElement(name="squaredEuclidean", namespace="http://www.dmg.org/PMML-4_2", type=SquaredEuclidean.class), @XmlElement(name="chebychev", namespace="http://www.dmg.org/PMML-4_2", type=Chebychev.class), @XmlElement(name="cityBlock", namespace="http://www.dmg.org/PMML-4_2", type=CityBlock.class), @XmlElement(name="minkowski", namespace="http://www.dmg.org/PMML-4_2", type=Minkowski.class), @XmlElement(name="simpleMatching", namespace="http://www.dmg.org/PMML-4_2", type=SimpleMatching.class), @XmlElement(name="jaccard", namespace="http://www.dmg.org/PMML-4_2", type=Jaccard.class), @XmlElement(name="tanimoto", namespace="http://www.dmg.org/PMML-4_2", type=Tanimoto.class), @XmlElement(name="binarySimilarity", namespace="http://www.dmg.org/PMML-4_2", type=BinarySimilarity.class)})
    protected Measure measure;

    public ComparisonMeasure() {
    }

    public ComparisonMeasure(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind value) {
        this.kind = value;
    }

    public CompareFunctionType getCompareFunction() {
        if (this.compareFunction == null) {
            return CompareFunctionType.ABS_DIFF;
        }
        return this.compareFunction;
    }

    public void setCompareFunction(CompareFunctionType value) {
        this.compareFunction = value;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Double value) {
        this.minimum = value;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Double value) {
        this.maximum = value;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public void setMeasure(Measure value) {
        this.measure = value;
    }

    public ComparisonMeasure withKind(Kind value) {
        this.setKind(value);
        return this;
    }

    public ComparisonMeasure withCompareFunction(CompareFunctionType value) {
        this.setCompareFunction(value);
        return this;
    }

    public ComparisonMeasure withMinimum(Double value) {
        this.setMinimum(value);
        return this;
    }

    public ComparisonMeasure withMaximum(Double value) {
        this.setMaximum(value);
        return this;
    }

    public ComparisonMeasure withExtensions(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtensions().add(value);
            }
        }
        return this;
    }

    public ComparisonMeasure withExtensions(Collection<Extension> values) {
        if (values != null) {
            this.getExtensions().addAll(values);
        }
        return this;
    }

    public ComparisonMeasure withMeasure(Measure value) {
        this.setMeasure(value);
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; status == VisitorAction.CONTINUE && this.extensions != null && i < this.extensions.size(); ++i) {
            status = this.extensions.get(i).accept(visitor);
        }
        if (status == VisitorAction.CONTINUE && this.measure != null) {
            status = this.measure.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Kind {
        DISTANCE("distance"),
        SIMILARITY("similarity");

        private final String value;

        private Kind(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Kind fromValue(String v) {
            for (Kind c : Kind.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

