/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.util;

import java.io.File;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private static final char TEMPLATE_PATH_SEPARATOR_CHAR = '/';
    private static final String TEMPLATE_PATH_SEPARATOR = "/";
    private static final char[] HEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private StringUtils() {
    }

    public static String templatePathToFileDir(String p_path) {
        int k = p_path.lastIndexOf(47);
        if (k <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(p_path.substring(0, k));
        int j = 1;
        for (int i = 0; i < sb.length() - 1; ++i) {
            if (sb.substring(i, j).equals(TEMPLATE_PATH_SEPARATOR)) {
                sb.replace(i, j, File.separator);
            }
            ++j;
        }
        return sb.toString();
    }

    public static boolean isGeneratedClassFilename(String p_className, String p_fileName) {
        String rest;
        return p_fileName.endsWith(".class") && p_fileName.startsWith(p_className) && ((rest = p_fileName.substring(p_className.length())).equals(".class") || rest.charAt(0) == '$');
    }

    public static String templatePathToClassName(String p_path) {
        StringBuilder sb = new StringBuilder(p_path);
        while (sb.length() > 0 && '/' == sb.charAt(0)) {
            sb.delete(0, 1);
        }
        int j = 1;
        for (int i = 0; i < sb.length() - 1; ++i) {
            if (sb.substring(i, j).equals(TEMPLATE_PATH_SEPARATOR)) {
                sb.replace(i, j, ".");
            }
            ++j;
        }
        return sb.toString();
    }

    public static String classToTemplatePath(Class<?> p_class) {
        return StringUtils.filePathToTemplatePath(StringUtils.classNameToFilePath(p_class.getName()));
    }

    public static String filePathToTemplatePath(String p_path) {
        return p_path.replaceAll(Pattern.quote(File.separator), TEMPLATE_PATH_SEPARATOR);
    }

    public static String classNameToFilePath(String p_className) {
        StringBuilder sb = new StringBuilder(File.separator);
        sb.append(p_className);
        for (int i = File.separator.length(); i < sb.length(); ++i) {
            if (sb.charAt(i) != '.') continue;
            sb.replace(i, i + 1, File.separator);
        }
        return sb.toString();
    }

    public static String capitalize(String p_string) {
        if (p_string == null) {
            return null;
        }
        if (p_string.length() == 0) {
            return p_string;
        }
        char[] chars = p_string.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuilder buffer = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buffer.append(HEXCHARS[(bytes[i] & 0xF0) >> 4]);
            buffer.append(HEXCHARS[bytes[i] & 0xF]);
        }
        return buffer.toString();
    }

    public static String hexify4(int p_int) {
        int i;
        String s = Integer.toHexString(i);
        int pad = 3;
        for (i = p_int; i > 16; i /= 16) {
            --pad;
        }
        return "000".substring(0, pad) + s;
    }

    public static void commaJoin(StringBuilder p_builder, Iterable<String> p_iterable) {
        boolean seenElement = false;
        for (String element : p_iterable) {
            if (seenElement) {
                p_builder.append(", ");
            } else {
                seenElement = true;
            }
            p_builder.append(element);
        }
    }
}

