/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.ArgNameNode;
import org.jamon.node.ArgValueNode;
import org.jamon.node.ParentArgNode;
import org.jamon.node.ParentArgWithDefaultNode;
import org.jamon.node.ParentArgsNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.OptionalValueTagEndDetector;
import org.jamon.parser.PositionalPushbackReader;

public final class ParentArgsParser
extends AbstractParser {
    private final ParentArgsNode m_parentArgsNode;
    public static final String MALFORMED_PARENT_ARGS_CLOSE = "Expecting parent arg declaration or '</%xargs>'";

    public ParentArgsParser(PositionalPushbackReader p_reader, ParserErrorsImpl p_errors, Location p_tagLocation) throws IOException {
        super(p_reader, p_errors);
        this.m_parentArgsNode = new ParentArgsNode(p_tagLocation);
        if (this.checkForTagClosure(p_tagLocation)) {
            while (true) {
                this.soakWhitespace();
                if (this.readChar('<')) {
                    Location location = this.m_reader.getLocation();
                    if (!this.checkToken("/%xargs>")) {
                        this.addError(location, MALFORMED_PARENT_ARGS_CLOSE);
                    }
                    this.soakWhitespace();
                    return;
                }
                try {
                    this.handleParentArg(this.m_parentArgsNode);
                }
                catch (ParserErrorImpl e) {
                    this.addError(e);
                    return;
                }
            }
        }
    }

    public ParentArgsNode getParentArgsNode() {
        return this.m_parentArgsNode;
    }

    private void handleParentArg(ParentArgsNode parentArgsNode) throws IOException, ParserErrorImpl {
        ArgNameNode argName = new ArgNameNode(this.m_reader.getNextLocation(), this.readIdentifier(true));
        this.soakWhitespace();
        if (this.readChar(';')) {
            parentArgsNode.addArg(new ParentArgNode(argName.getLocation(), argName));
        } else if (this.readChar('=')) {
            this.readChar('>');
            this.soakWhitespace();
            Location valueLocation = this.m_reader.getNextLocation();
            parentArgsNode.addArg(new ParentArgWithDefaultNode(argName.getLocation(), argName, new ArgValueNode(valueLocation, this.readJava(valueLocation, new OptionalValueTagEndDetector()))));
        } else {
            throw new ParserErrorImpl(this.m_reader.getNextLocation(), "Expecting a ';', '=' or '=>'");
        }
    }
}

