/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbstractArgsNode;
import org.jamon.node.ArgNameNode;
import org.jamon.node.ArgTypeNode;
import org.jamon.node.FragmentArgsNode;
import org.jamon.parser.AbstractArgsParser;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.PositionalPushbackReader;

public class FragmentArgsParser
extends AbstractArgsParser {
    public static final String EXPECTING_GREATER = "Expecting '>'";
    public static final String NEED_SEMI = "Expecting a ';'";
    public static final String FRAGMENT_ARGUMENT_HAS_NO_NAME = "Fragment argument has no name";
    private String m_fragmentName;
    private FragmentArgsNode m_fragmentArgsNode;

    public FragmentArgsParser(PositionalPushbackReader p_reader, ParserErrorsImpl p_errors, Location p_tagLocation) throws IOException, ParserErrorImpl {
        super(p_reader, p_errors, p_tagLocation);
    }

    public FragmentArgsNode getFragmentArgsNode() {
        return this.m_fragmentArgsNode;
    }

    protected boolean handleDefaultValue(AbstractArgsNode argsNode, ArgTypeNode argType, ArgNameNode argName) {
        return false;
    }

    protected void checkArgsTagEnd() throws IOException {
        if (!this.checkToken("/%frag>")) {
            this.addError(this.m_reader.getLocation(), "malformed </%args> tag");
        }
    }

    protected String postArgNameTokenError() {
        return NEED_SEMI;
    }

    protected AbstractArgsNode makeArgsNode(Location p_tagLocation) {
        this.m_fragmentArgsNode = new FragmentArgsNode(p_tagLocation, this.m_fragmentName);
        return this.m_fragmentArgsNode;
    }

    protected boolean finishOpenTag(Location p_tagLocation) throws IOException {
        if (!this.soakWhitespace()) {
            this.m_fragmentName = "";
            this.addError(p_tagLocation, FRAGMENT_ARGUMENT_HAS_NO_NAME);
        } else {
            try {
                this.m_fragmentName = this.readIdentifierOrThrow();
            }
            catch (AbstractParser.NotAnIdentifierException e) {
                this.addError(p_tagLocation, FRAGMENT_ARGUMENT_HAS_NO_NAME);
            }
        }
        this.soakWhitespace();
        if (this.readChar('/')) {
            if (!this.readChar('>')) {
                this.addError(this.m_reader.getCurrentNodeLocation(), EXPECTING_GREATER);
            } else {
                this.m_fragmentArgsNode = new FragmentArgsNode(p_tagLocation, this.m_fragmentName);
                this.soakWhitespace();
            }
            return false;
        }
        return this.checkForTagClosure(p_tagLocation);
    }
}

