/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbstractArgsNode;
import org.jamon.node.ArgNameNode;
import org.jamon.node.ArgTypeNode;
import org.jamon.node.ArgValueNode;
import org.jamon.node.ArgsNode;
import org.jamon.node.OptionalArgNode;
import org.jamon.parser.AbstractArgsParser;
import org.jamon.parser.OptionalValueTagEndDetector;
import org.jamon.parser.PositionalPushbackReader;

public class ArgsParser
extends AbstractArgsParser {
    private ArgsNode m_argsNode;
    public static final String EOF_LOOKING_FOR_SEMI = "Reached end of file while looking for ';'";

    public ArgsParser(PositionalPushbackReader p_reader, ParserErrorsImpl p_errors, Location p_tagLocation) throws IOException, ParserErrorImpl {
        super(p_reader, p_errors, p_tagLocation);
    }

    public ArgsNode getArgsNode() {
        return this.m_argsNode;
    }

    protected AbstractArgsNode makeArgsNode(Location p_tagLocation) {
        this.m_argsNode = new ArgsNode(p_tagLocation);
        return this.m_argsNode;
    }

    protected String postArgNameTokenError() {
        return "Expecting a ';', '=' or '=>'";
    }

    protected void checkArgsTagEnd() throws IOException {
        if (!this.checkToken("/%args>")) {
            this.addError(this.m_reader.getLocation(), "malformed </%args> tag");
        }
    }

    protected boolean handleDefaultValue(AbstractArgsNode argsNode, ArgTypeNode argType, ArgNameNode argName) throws IOException, ParserErrorImpl {
        if (this.readChar('=')) {
            this.readChar('>');
            this.soakWhitespace();
            Location valueLocation = this.m_reader.getNextLocation();
            argsNode.addArg(new OptionalArgNode(argType.getLocation(), argType, argName, new ArgValueNode(valueLocation, this.readJava(valueLocation, new OptionalValueTagEndDetector()))));
            return true;
        }
        return false;
    }

    protected boolean finishOpenTag(Location p_tagLocation) throws IOException {
        return this.checkForTagClosure(p_tagLocation);
    }
}

