/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbstractPathNode;
import org.jamon.parser.ClassNameParser;
import org.jamon.parser.PathParser;
import org.jamon.parser.PositionalPushbackReader;
import org.jamon.parser.TagEndDetector;
import org.jamon.parser.TypeNameParser;

public class AbstractParser {
    public static final String MALFORMED_TAG_ERROR = "Malformed tag";
    public static final String EOF_IN_JAVA_QUOTE_ERROR = "Reached end of file while inside a java quote";
    public static final String NOT_AN_IDENTIFIER_ERROR = "identifier exepected";
    public static final String BAD_JAVA_TYPE_SPECIFIER = "Bad java type specifier";
    public static final String BAD_ARGS_CLOSE_TAG = "malformed </%args> tag";
    public static final String INCOMPLETE_ARRAY_SPECIFIER_ERROR = "Expecting ']'";
    protected final PositionalPushbackReader m_reader;
    protected final ParserErrorsImpl m_errors;

    public AbstractParser(PositionalPushbackReader p_reader, ParserErrorsImpl p_errors) {
        this.m_reader = p_reader;
        this.m_errors = p_errors;
    }

    protected boolean soakWhitespace() throws IOException {
        int c;
        boolean whitespaceSeen = false;
        while ((c = this.m_reader.read()) >= 0 && Character.isWhitespace((char)c)) {
            whitespaceSeen = true;
        }
        this.m_reader.unread(c);
        return whitespaceSeen;
    }

    protected void addError(Location p_location, String p_message) {
        this.m_errors.addError(new ParserErrorImpl(p_location, p_message));
    }

    protected void addError(ParserErrorImpl p_error) {
        this.m_errors.addError(p_error);
    }

    protected String readIdentifierOrThrow() throws IOException, NotAnIdentifierException {
        StringBuilder builder = new StringBuilder();
        int c = this.m_reader.read();
        if (c <= 0 || !Character.isJavaIdentifierStart((char)c)) {
            this.m_reader.unread(c);
            throw new NotAnIdentifierException();
        }
        builder.append((char)c);
        while ((c = this.m_reader.read()) >= 0 && Character.isJavaIdentifierPart((char)c)) {
            builder.append((char)c);
        }
        this.m_reader.unread(c);
        return builder.toString();
    }

    protected String readIdentifier(boolean p_addErrorIfNoneFound) throws IOException {
        try {
            return this.readIdentifierOrThrow();
        }
        catch (NotAnIdentifierException e) {
            if (p_addErrorIfNoneFound) {
                this.addError(this.m_reader.getNextLocation(), NOT_AN_IDENTIFIER_ERROR);
            }
            return "";
        }
    }

    protected boolean readChar(char p_char) throws IOException {
        int c = this.m_reader.read();
        if (c == p_char) {
            return true;
        }
        this.m_reader.unread(c);
        return false;
    }

    protected String readUntil(String p_end, Location p_startLocation) throws IOException {
        int n;
        StringBuilder buffer = new StringBuilder();
        int charsSeen = 0;
        int n2 = -1;
        while (charsSeen < p_end.length() && (n = this.m_reader.read()) >= 0) {
            if (p_end.charAt(charsSeen) == n) {
                ++charsSeen;
                continue;
            }
            if (charsSeen > 0) {
                buffer.append(p_end.substring(0, charsSeen));
                charsSeen = 0;
                this.m_reader.unread(n);
                continue;
            }
            buffer.append((char)n);
        }
        if (n < 0) {
            this.addError(p_startLocation, AbstractParser.eofErrorMessage(p_end));
        }
        return buffer.toString();
    }

    public static String eofErrorMessage(String p_end) {
        return "Reached end of file while looking for '" + p_end + "'";
    }

    protected String readJava(Location p_startLocation, TagEndDetector p_tagEndDetector) throws IOException, ParserErrorImpl {
        StringBuilder buffer = new StringBuilder();
        int c = -1;
        boolean inString = false;
        boolean inChar = false;
        Location quoteStart = null;
        while ((c = this.m_reader.read()) >= 0) {
            int endTokenLength;
            switch (c) {
                case 34: {
                    boolean bl = inString = !inChar && !inString;
                    if (inString) {
                        quoteStart = this.m_reader.getLocation();
                        p_tagEndDetector.resetEndMatch();
                        break;
                    }
                    quoteStart = null;
                    break;
                }
                case 39: {
                    boolean bl = inChar = !inString && !inChar;
                    if (inChar) {
                        quoteStart = this.m_reader.getLocation();
                        p_tagEndDetector.resetEndMatch();
                        break;
                    }
                    quoteStart = null;
                    break;
                }
                case 92: {
                    if (!inString && !inChar) break;
                    buffer.append((char)c);
                    c = this.m_reader.read();
                    if (c >= 0) break;
                    this.m_reader.unread(c);
                }
            }
            buffer.append((char)c);
            if (inString || inChar || (endTokenLength = p_tagEndDetector.checkEnd((char)c)) <= 0) continue;
            buffer.delete(buffer.length() - endTokenLength, buffer.length());
            return buffer.toString();
        }
        if (quoteStart != null) {
            throw new ParserErrorImpl(quoteStart, EOF_IN_JAVA_QUOTE_ERROR);
        }
        throw p_tagEndDetector.getEofError(p_startLocation);
    }

    protected boolean checkForTagClosure(Location p_tagLocation) throws IOException {
        if (this.readChar('>')) {
            return true;
        }
        this.addError(p_tagLocation, MALFORMED_TAG_ERROR);
        return false;
    }

    protected boolean checkToken(String p_token) throws IOException {
        for (int i = 0; i < p_token.length(); ++i) {
            if (this.readChar(p_token.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected String readType(Location p_location) throws IOException {
        try {
            return new TypeNameParser(p_location, this.m_reader, this.m_errors).getType();
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
            return "";
        }
    }

    protected String readClassName(Location p_location) throws IOException {
        try {
            return new ClassNameParser(p_location, this.m_reader, this.m_errors).getType();
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
            return "";
        }
    }

    protected AbstractPathNode parsePath() throws IOException {
        return new PathParser(this.m_reader, this.m_errors).getPathNode();
    }

    protected boolean readAndAppendChar(char p_char, StringBuilder builder) throws IOException {
        if (this.readChar(p_char)) {
            builder.append(p_char);
            return true;
        }
        return false;
    }

    protected static class NotAnIdentifierException
    extends Exception {
        private static final long serialVersionUID = 2006091701L;

        protected NotAnIdentifierException() {
        }
    }
}

