/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.jamon.api.TemplateLocation;
import org.jamon.api.TemplateSource;
import org.jamon.compiler.TemplateResourceLocation;

public class ResourceTemplateSource
implements TemplateSource {
    private final ClassLoader m_classLoader;
    private final String m_templateSourceDir;
    private final String m_extension;

    public ResourceTemplateSource(ClassLoader p_classLoader, String p_templateSourceDir) {
        this(p_classLoader, p_templateSourceDir, "jamon");
    }

    public ResourceTemplateSource(ClassLoader p_classLoader, String p_templateSourceDir, String p_extension) {
        this.m_classLoader = p_classLoader;
        this.m_templateSourceDir = p_templateSourceDir;
        this.m_extension = p_extension == null || p_extension.length() == 0 ? "" : "." + p_extension;
    }

    public long lastModified(String p_templatePath) throws IOException {
        return this.getTemplate(p_templatePath).getLastModified();
    }

    public boolean available(String p_templatePath) {
        return this.getUrl(p_templatePath) != null;
    }

    public InputStream getStreamFor(String p_templatePath) throws IOException {
        return this.getTemplate(p_templatePath).getInputStream();
    }

    public String getExternalIdentifier(String p_templatePath) {
        return p_templatePath;
    }

    private URL getUrl(String p_templatePath) {
        return this.m_classLoader.getResource(this.resourceName(p_templatePath));
    }

    private String resourceName(String p_templatePath) {
        return this.m_templateSourceDir + p_templatePath + this.m_extension;
    }

    private URLConnection getTemplate(String p_templatePath) throws IOException {
        return this.getUrl(p_templatePath).openConnection();
    }

    public TemplateLocation getTemplateLocation(String p_templatePath) {
        return new TemplateResourceLocation(this.resourceName(p_templatePath));
    }

    public void loadProperties(String p_dirPath, Properties p_properties) throws IOException {
        InputStream inputStream = this.m_classLoader.getResourceAsStream(this.m_templateSourceDir + p_dirPath + "/jamon.properties");
        if (inputStream != null) {
            p_properties.load(inputStream);
        }
    }
}

