/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.jamon.api.Location;
import org.jamon.api.TemplateSource;
import org.jamon.codegen.Analyzer;
import org.jamon.codegen.EncodingReader;
import org.jamon.codegen.EscapingDirective;
import org.jamon.codegen.TemplateDescription;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.emit.EmitMode;
import org.jamon.node.LocationImpl;
import org.jamon.node.TopNode;
import org.jamon.parser.TopLevelParser;
import org.jamon.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateDescriber {
    private static final String JAMON_CONTEXT_TYPE_KEY = "org.jamon.contextType";
    private static final String EMIT_MODE_KEY = "org.jamon.emitMode";
    private static final String ESCAPING_KEY = "org.jamon.escape";
    private final Map<String, TemplateDescription> m_descriptionCache = new HashMap<String, TemplateDescription>();
    private final TemplateSource m_templateSource;
    private final ClassLoader m_classLoader;
    private static final String ALIAS_PROPERTY_PREFIX = "org.jamon.alias.";

    public TemplateDescriber(TemplateSource p_templateSource, ClassLoader p_classLoader) {
        this.m_templateSource = p_templateSource;
        this.m_classLoader = p_classLoader;
    }

    public TemplateDescription getTemplateDescription(String p_path, Location p_location) throws IOException, ParserErrorImpl {
        return this.getTemplateDescription(p_path, p_location, new HashSet<String>());
    }

    public TemplateDescription getTemplateDescription(String p_path, Location p_location, Set<String> p_children) throws IOException, ParserErrorImpl {
        if (this.m_descriptionCache.containsKey(p_path)) {
            return this.m_descriptionCache.get(p_path);
        }
        TemplateDescription desc = this.computeTemplateDescription(p_path, p_location, p_children);
        this.m_descriptionCache.put(p_path, desc);
        return desc;
    }

    private TemplateDescription computeTemplateDescription(String p_path, Location p_location, Set<String> p_children) throws IOException, ParserErrorImpl {
        if (this.m_templateSource.available(p_path)) {
            return new TemplateDescription(new Analyzer(p_path, this, p_children).analyze());
        }
        try {
            return new TemplateDescription(this.m_classLoader.loadClass(StringUtils.templatePathToClassName(p_path)));
        }
        catch (ClassNotFoundException e) {
            throw new ParserErrorImpl(p_location, "Unable to find template or class for " + p_path);
        }
        catch (NoSuchFieldException e) {
            throw new ParserErrorImpl(p_location, "Malformed class for " + p_path);
        }
    }

    public TopNode parseTemplate(String p_path) throws IOException {
        InputStream stream = this.m_templateSource.getStreamFor(p_path);
        try {
            TopNode topNode = new TopLevelParser(this.m_templateSource.getTemplateLocation(p_path), new EncodingReader(stream)).parse().getRootNode();
            return topNode;
        }
        catch (EncodingReader.Exception e) {
            throw new ParserErrorsImpl(new ParserErrorImpl(new LocationImpl(this.m_templateSource.getTemplateLocation(p_path), 1, e.getPos()), e.getMessage()));
        }
        catch (ParserErrorsImpl e) {
            throw e;
        }
        finally {
            stream.close();
        }
    }

    public String getExternalIdentifier(String p_path) {
        return this.m_templateSource.getExternalIdentifier(p_path);
    }

    private Properties getProperties(String p_path) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(p_path, "/");
        StringBuffer partialPath = new StringBuffer("/");
        Properties properties = new Properties();
        while (tokenizer.hasMoreTokens()) {
            this.m_templateSource.loadProperties(partialPath.toString(), properties);
            String nextComponent = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            partialPath.append(nextComponent);
            partialPath.append("/");
        }
        return properties;
    }

    public Map<String, String> getAliases(String p_path) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties props = this.getProperties(p_path);
        for (Object okey : props.keySet()) {
            String key = (String)okey;
            if (!key.startsWith(ALIAS_PROPERTY_PREFIX)) continue;
            String aliasName = key.substring(ALIAS_PROPERTY_PREFIX.length());
            String alias = props.getProperty(key);
            if (alias == null || alias.trim().length() == 0) {
                result.remove(aliasName);
                continue;
            }
            result.put(aliasName, props.getProperty(key));
        }
        return result;
    }

    public String getJamonContextType(String p_path) throws IOException {
        String contextType = this.getProperties(p_path).getProperty(JAMON_CONTEXT_TYPE_KEY, "").trim();
        return contextType.length() > 0 ? contextType : null;
    }

    public EmitMode getEmitMode(String p_path) throws IOException {
        String emitModeName = this.getProperties(p_path).getProperty(EMIT_MODE_KEY);
        if (emitModeName != null) {
            EmitMode emitMode = EmitMode.fromString((String)emitModeName);
            if (emitMode == null) {
                throw new RuntimeException("Unknown emit mode: " + emitModeName);
            }
            return emitMode;
        }
        return EmitMode.STANDARD;
    }

    public EscapingDirective getEscaping(String p_path) throws IOException {
        return EscapingDirective.get(this.getProperties(p_path).getProperty(ESCAPING_KEY));
    }
}

