/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.Map;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbsolutePathNode;
import org.jamon.node.DepthFirstAnalysisAdapter;
import org.jamon.node.NamedAliasPathNode;
import org.jamon.node.PathElementNode;
import org.jamon.node.RootAliasPathNode;
import org.jamon.node.UpdirNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PathAdapter
extends DepthFirstAnalysisAdapter {
    private final String m_templateDir;
    private final Map<String, String> m_aliases;
    private final ParserErrorsImpl m_errors;
    private final StringBuilder m_path = new StringBuilder();
    private boolean m_absolutePath = false;

    public PathAdapter(String p_templateDir, Map<String, String> p_aliases, ParserErrorsImpl p_errors) {
        this.m_templateDir = p_templateDir;
        this.m_aliases = p_aliases;
        this.m_errors = p_errors;
    }

    public String getPath() {
        return this.m_path.substring(0, this.m_path.length() - 1);
    }

    @Override
    public void inAbsolutePathNode(AbsolutePathNode p_node) {
        this.m_absolutePath = true;
        this.m_path.append('/');
    }

    @Override
    public void inUpdirNode(UpdirNode p_updir) {
        int lastSlash;
        if (!this.m_absolutePath) {
            this.m_path.insert(0, this.m_templateDir);
            this.m_absolutePath = true;
        }
        if ((lastSlash = this.m_path.toString().lastIndexOf(47, this.m_path.length() - 2)) < 0) {
            this.m_errors.addError("Cannot reference templates above the root", p_updir.getLocation());
        }
        this.m_path.delete(lastSlash + 1, this.m_path.length());
    }

    @Override
    public void inPathElementNode(PathElementNode p_relativePath) {
        this.m_path.append(p_relativePath.getName());
        this.m_path.append('/');
    }

    @Override
    public void inNamedAliasPathNode(NamedAliasPathNode p_node) {
        String alias = this.m_aliases.get(p_node.getAlias());
        if (alias == null) {
            this.m_errors.addError("Unknown alias " + p_node.getAlias(), p_node.getLocation());
        } else {
            this.m_path.append(alias);
            this.m_path.append('/');
        }
    }

    @Override
    public void inRootAliasPathNode(RootAliasPathNode p_node) {
        String alias = this.m_aliases.get("/");
        if (alias == null) {
            this.m_errors.addError("No root alias", p_node.getLocation());
        } else {
            this.m_path.append(alias);
            this.m_path.append('/');
        }
    }
}

