/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.RequiredArgument;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.ArgValueNode;
import org.jamon.node.ParentArgNode;
import org.jamon.node.ParentArgWithDefaultNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritedArgs {
    private final String m_parentName;
    private final ParserErrorsImpl m_errors;
    private final Set<AbstractArgument> m_visibleArgs = new HashSet<AbstractArgument>();
    private final Collection<RequiredArgument> m_requiredArgs;
    private final Collection<OptionalArgument> m_optionalArgs;
    private final Collection<FragmentArgument> m_fragmentArgs;
    private final Map<OptionalArgument, String> m_defaultOverrides = new HashMap<OptionalArgument, String>();

    public InheritedArgs(String p_parentName, Collection<RequiredArgument> p_requiredArgs, Collection<OptionalArgument> p_optionalArgs, Collection<FragmentArgument> p_fragmentArgs, ParserErrorsImpl p_errors) {
        this.m_parentName = p_parentName;
        this.m_errors = p_errors;
        this.m_requiredArgs = p_requiredArgs;
        this.m_optionalArgs = p_optionalArgs;
        this.m_fragmentArgs = p_fragmentArgs;
    }

    public Collection<AbstractArgument> getVisibleArgs() {
        return this.m_visibleArgs;
    }

    public boolean isArgVisible(AbstractArgument p_arg) {
        return this.m_visibleArgs.contains(p_arg);
    }

    public void addParentArg(ParentArgNode p_node) {
        String name = p_node.getName().getName();
        ArgValueNode value = p_node instanceof ParentArgWithDefaultNode ? ((ParentArgWithDefaultNode)p_node).getValue() : null;
        for (RequiredArgument requiredArgument : this.m_requiredArgs) {
            if (!requiredArgument.getName().equals(name)) continue;
            if (value == null) {
                this.m_visibleArgs.add(requiredArgument);
            } else {
                this.m_errors.addError(name + " is an inherited required argument, and may not be given a default value", value.getLocation());
            }
            return;
        }
        for (OptionalArgument optionalArgument : this.m_optionalArgs) {
            if (!optionalArgument.getName().equals(name)) continue;
            if (value != null) {
                this.m_defaultOverrides.put(optionalArgument, value.getValue().trim());
            }
            this.m_visibleArgs.add(optionalArgument);
            return;
        }
        for (FragmentArgument fragmentArgument : this.m_fragmentArgs) {
            if (!fragmentArgument.getName().equals(name)) continue;
            if (value == null) {
                this.m_visibleArgs.add(fragmentArgument);
            } else {
                this.m_errors.addError(name + " is an inherited fragment argument, and may not be given a default value", value.getLocation());
            }
            return;
        }
        this.m_errors.addError(this.m_parentName + " does not have an arg named " + name, p_node.getName().getLocation());
    }

    public String getDefaultValue(OptionalArgument p_arg) {
        return this.m_defaultOverrides.get(p_arg);
    }

    public Collection<OptionalArgument> getOptionalArgsWithNewDefaultValues() {
        return this.m_defaultOverrides.keySet();
    }
}

