/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.codegen.AbstractCallStatement;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.ParamValues;
import org.jamon.codegen.PathUtils;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.TemplateDescription;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.node.GenericCallParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentCallStatement
extends AbstractCallStatement {
    private static int m_uniqueId = 0;
    private final List<GenericCallParam> m_genericParams;
    private final String m_callingTemlpateJamonContextType;

    ComponentCallStatement(String p_path, ParamValues p_params, Location p_location, String p_templateIdentifier, List<GenericCallParam> p_genericParams, String p_callingTemlpateJamonContextType) {
        super(p_path, p_params, p_location, p_templateIdentifier);
        this.m_genericParams = p_genericParams;
        this.m_callingTemlpateJamonContextType = p_callingTemlpateJamonContextType;
    }

    @Override
    protected String getFragmentIntfName(FragmentUnit p_fragmentUnitIntf) {
        return this.getComponentProxyClassName() + "." + p_fragmentUnitIntf.getFragmentInterfaceName(false) + this.getGenericParams();
    }

    @Override
    public void generateSource(CodeWriter p_writer, TemplateDescriber p_describer) throws ParserErrorImpl {
        TemplateDescription desc;
        this.generateSourceLine(p_writer);
        p_writer.openBlock();
        try {
            desc = p_describer.getTemplateDescription(this.getPath(), this.getLocation());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (desc.getJamonContextType() != null && this.m_callingTemlpateJamonContextType == null) {
            throw new ParserErrorImpl(this.getLocation(), "Calling component does not have a jamonContext, but called component " + this.getPath() + " expects one of type " + desc.getJamonContextType());
        }
        if (this.hasGenericParams() && desc.getGenericParamsCount() != this.getGenericParamCount()) {
            throw new ParserErrorImpl(this.getLocation(), "Call to component " + this.getPath() + " provides " + this.getGenericParamCount() + " generic params, but " + this.getPath() + " only expects " + desc.getGenericParamsCount());
        }
        this.makeFragmentImplClasses(desc.getFragmentInterfaces(), p_writer, p_describer);
        String instanceVar = ComponentCallStatement.getUniqueName();
        p_writer.println(this.getComponentProxyClassName() + this.getGenericParams() + " " + instanceVar + " = " + "new " + this.getComponentProxyClassName() + this.getGenericParams() + "(this.getTemplateManager());");
        if (desc.getJamonContextType() != null) {
            p_writer.println(instanceVar + ".setJamonContext(jamonContext);");
        }
        for (OptionalArgument arg : desc.getOptionalArgs()) {
            String value = this.getParams().getOptionalArgValue(arg.getName());
            if (value == null) continue;
            p_writer.println(instanceVar + "." + arg.getSetterName() + "(" + value + ");");
        }
        p_writer.print(instanceVar + ".renderNoFlush");
        p_writer.openList();
        p_writer.printListElement("jamonWriter");
        this.getParams().generateRequiredArgs(desc.getRequiredArgs(), p_writer);
        this.generateFragmentParams(p_writer, desc.getFragmentInterfaces());
        p_writer.closeList();
        p_writer.println(";");
        this.checkSuppliedParams();
        p_writer.closeBlock();
    }

    protected boolean hasGenericParams() {
        return !this.m_genericParams.isEmpty();
    }

    protected int getGenericParamCount() {
        return this.m_genericParams.size();
    }

    protected String getGenericParams() {
        if (this.hasGenericParams()) {
            StringBuilder builder = new StringBuilder();
            builder.append('<');
            boolean paramsAdded = false;
            for (GenericCallParam param : this.m_genericParams) {
                if (paramsAdded) {
                    builder.append(", ");
                }
                builder.append(param.getClassName());
                paramsAdded = true;
            }
            builder.append('>');
            return builder.toString();
        }
        return "";
    }

    private String getComponentProxyClassName() {
        return PathUtils.getFullyQualifiedIntfClassName(this.getPath());
    }

    private static String getUniqueName() {
        return "__jamon__var_" + m_uniqueId++;
    }
}

