/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jamon.api.Location;
import org.jamon.codegen.AbstractStatement;
import org.jamon.codegen.ArgNames;
import org.jamon.codegen.CallStatement;
import org.jamon.codegen.ClassNames;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.ParamValues;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCallStatement
extends AbstractStatement
implements CallStatement {
    private final String m_path;
    private final ParamValues m_params;
    private final Map<String, FragmentUnit> m_fragParams = new HashMap<String, FragmentUnit>();
    private static final String FRAGMENT_IMPL_PREFIX = "__jamon__instanceOf__";
    private final Map<FragmentUnit, String> m_fragmentImplNames = new HashMap<FragmentUnit, String>();

    AbstractCallStatement(String p_path, ParamValues p_params, Location p_location, String p_templateIdentifier) {
        super(p_location, p_templateIdentifier);
        this.m_path = p_path;
        this.m_params = p_params;
    }

    @Override
    public void addFragmentImpl(FragmentUnit p_unit, ParserErrorsImpl p_errors) {
        this.m_fragParams.put(p_unit.getName(), p_unit);
    }

    protected abstract String getFragmentIntfName(FragmentUnit var1);

    private String getFragmentImplName(CodeWriter p_writer, FragmentUnit p_fragmentUnitIntf) {
        if (!this.m_fragmentImplNames.containsKey(p_fragmentUnitIntf)) {
            this.m_fragmentImplNames.put(p_fragmentUnitIntf, FRAGMENT_IMPL_PREFIX + p_writer.nextFragmentImplCounter() + "__" + p_fragmentUnitIntf.getFragmentInterfaceName(false));
        }
        return this.m_fragmentImplNames.get(p_fragmentUnitIntf);
    }

    private void makeFragmentImplClass(FragmentUnit p_fragmentUnitIntf, CodeWriter p_writer, TemplateDescriber p_describer) throws ParserErrorImpl {
        FragmentUnit fragmentUnitImpl = this.m_fragParams.remove(p_fragmentUnitIntf.getName());
        if (fragmentUnitImpl == null) {
            throw new ParserErrorImpl(this.getLocation(), "Call is missing fragment " + p_fragmentUnitIntf.getName());
        }
        p_writer.println("class " + this.getFragmentImplName(p_writer, p_fragmentUnitIntf));
        p_writer.println("  extends " + ClassNames.BASE_TEMPLATE);
        p_writer.println("  implements " + this.getFragmentIntfName(p_fragmentUnitIntf));
        p_writer.openBlock();
        p_writer.println("public " + this.getFragmentImplName(p_writer, p_fragmentUnitIntf) + "(" + ClassNames.TEMPLATE_MANAGER + " p_manager)");
        p_writer.openBlock();
        p_writer.println("super(p_manager);");
        p_writer.closeBlock();
        p_writer.print("public " + ClassNames.RENDERER + " makeRenderer");
        p_writer.openList();
        fragmentUnitImpl.printRenderArgsDecl(p_writer);
        p_writer.closeList();
        p_writer.println();
        p_writer.openBlock();
        p_writer.print("return new " + ClassNames.ABSTRACT_RENDERER + "()");
        p_writer.openBlock();
        p_writer.println("@Override");
        p_writer.println("public void renderTo(" + ArgNames.ANNOTATED_WRITER_DECL + ")");
        p_writer.println("  throws " + ClassNames.IOEXCEPTION);
        p_writer.openBlock();
        p_writer.print("renderNoFlush");
        p_writer.openList();
        p_writer.printListElement("jamonWriter");
        fragmentUnitImpl.printRenderArgs(p_writer);
        p_writer.closeList();
        p_writer.println(";");
        p_writer.closeBlock();
        p_writer.closeBlock(";");
        p_writer.closeBlock();
        p_writer.print("public void renderNoFlush");
        p_writer.openList();
        p_writer.printListElement(ArgNames.ANNOTATED_WRITER_DECL);
        fragmentUnitImpl.printRenderArgsDecl(p_writer);
        p_writer.closeList();
        p_writer.println(" throws " + ClassNames.IOEXCEPTION);
        fragmentUnitImpl.generateRenderBody(p_writer, p_describer);
        p_writer.closeBlock();
    }

    protected void makeFragmentImplClasses(List<FragmentArgument> p_fragmentInterfaces, CodeWriter p_writer, TemplateDescriber p_describer) throws ParserErrorImpl {
        if (this.m_fragParams.size() == 1 && this.m_fragParams.keySet().iterator().next() == null) {
            if (p_fragmentInterfaces.size() == 0) {
                throw new ParserErrorImpl(this.getLocation(), "Call provides a fragment, but none are expected");
            }
            if (p_fragmentInterfaces.size() > 1) {
                throw new ParserErrorImpl(this.getLocation(), "Call must provide multiple fragments");
            }
            this.m_fragParams.put(p_fragmentInterfaces.get(0).getName(), this.m_fragParams.remove(null));
        }
        for (FragmentArgument arg : p_fragmentInterfaces) {
            this.makeFragmentImplClass(arg.getFragmentUnit(), p_writer, p_describer);
        }
    }

    protected void generateFragmentParams(CodeWriter p_writer, List<FragmentArgument> p_fragmentInterfaces) {
        for (FragmentArgument fragmentArgument : p_fragmentInterfaces) {
            p_writer.printListElement("new " + this.getFragmentImplName(p_writer, fragmentArgument.getFragmentUnit()) + "(this.getTemplateManager())");
        }
    }

    protected void checkSuppliedParams() throws ParserErrorImpl {
        if (this.getParams().hasUnusedParams()) {
            throw this.constructExtraParamsException("arguments", this.getParams().getUnusedParams());
        }
        if (!this.m_fragParams.isEmpty()) {
            throw this.constructExtraParamsException("fragments", this.m_fragParams.keySet());
        }
    }

    ParserErrorImpl constructExtraParamsException(String p_paramType, Iterable<String> p_extraParams) {
        StringBuilder message = new StringBuilder("Call provides unused ");
        message.append(p_paramType);
        message.append(" ");
        StringUtils.commaJoin(message, p_extraParams);
        return new ParserErrorImpl(this.getLocation(), message.toString());
    }

    protected final String getPath() {
        return this.m_path;
    }

    protected final ParamValues getParams() {
        return this.m_params;
    }
}

