/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import org.jamon.api.Location;
import org.jamon.codegen.CodeWriter;
import org.jamon.node.ArgNode;
import org.jamon.util.StringUtils;

public abstract class AbstractArgument {
    private final String m_name;
    private final String m_type;
    private final Location m_location;

    public AbstractArgument(String p_name, String p_type, Location p_location) {
        this.m_name = p_name;
        this.m_type = p_type;
        this.m_location = p_location;
    }

    public AbstractArgument(ArgNode p_arg) {
        this(p_arg.getName().getName(), p_arg.getType().getType(), p_arg.getLocation());
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    public Location getLocation() {
        return this.m_location;
    }

    public String getSetterName() {
        return "set" + StringUtils.capitalize(this.getName());
    }

    public String getGetterName() {
        return "get" + StringUtils.capitalize(this.getName());
    }

    public void generateImplDataCode(CodeWriter p_writer) {
        p_writer.printLocation(this.getLocation());
        p_writer.println("public void " + this.getSetterName() + "(" + this.getType() + " " + this.getName() + ")");
        p_writer.openBlock();
        this.generateImplDataSetterCode(p_writer);
        p_writer.closeBlock();
        p_writer.println("public " + this.getType() + " " + this.getGetterName() + "()");
        p_writer.openBlock();
        p_writer.println("return m_" + this.getName() + ";");
        p_writer.closeBlock();
        p_writer.println("private " + this.getType() + " m_" + this.getName() + ";");
    }

    protected void generateImplDataSetterCode(CodeWriter p_writer) {
        p_writer.printLocation(this.getLocation());
        p_writer.println("m_" + this.getName() + " = " + this.getName() + ";");
    }
}

