/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.maven.FileFilter;

public final class BundleCreator {
    private final MavenProject project;
    private final FileFilter fileFilter;

    public BundleCreator(MavenProject project, FileFilter fileFilter) {
        this.project = project;
        this.fileFilter = fileFilter;
    }

    public IBundleCoverage createBundle(ExecutionDataStore executionDataStore) throws IOException {
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)builder);
        File classesDir = new File(this.project.getBuild().getOutputDirectory());
        List filesToAnalyze = FileUtils.getFiles((File)classesDir, (String)this.fileFilter.getIncludes(), (String)this.fileFilter.getExcludes());
        for (File file : filesToAnalyze) {
            analyzer.analyzeAll(file);
        }
        return builder.getBundle(this.project.getName());
    }
}

