/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.util;

import java.lang.reflect.AccessibleObject;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class Accessibles {
    public static void setAccessibleIgnoringExceptions(AccessibleObject o, boolean accessible) {
        try {
            Accessibles.setAccessible(o, accessible);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void makeAccessible(AccessibleObject o) {
        Accessibles.setAccessible(o, true);
    }

    public static void setAccessible(AccessibleObject o, boolean accessible) {
        AccessController.doPrivileged(new SetAccessibleAction(o, accessible));
    }

    private Accessibles() {
    }

    private static class SetAccessibleAction
    implements PrivilegedAction<Void> {
        private final AccessibleObject o;
        private final boolean accessible;

        SetAccessibleAction(AccessibleObject o, boolean accessible) {
            this.o = o;
            this.accessible = accessible;
        }

        @Override
        public Void run() {
            this.o.setAccessible(this.accessible);
            return null;
        }
    }
}

