/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.type;

import org.fest.reflect.exception.ReflectionError;
import org.fest.util.Strings;

public final class TypeLoader {
    private final String name;
    private final ClassLoader classLoader;

    static TypeLoader newLoader(String name, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("The given class loader should not be null");
        }
        return new TypeLoader(name, classLoader);
    }

    private TypeLoader(String name, ClassLoader classLoader) {
        this.name = name;
        this.classLoader = classLoader;
    }

    public Class<?> load() {
        try {
            return this.loadType();
        }
        catch (Exception e) {
            throw new ReflectionError(this.unableToLoadClassMessage(null), e);
        }
    }

    public <T> Class<? extends T> loadAs(Class<T> type) {
        if (type == null) {
            throw new NullPointerException("The given type should not be null");
        }
        try {
            return this.loadType().asSubclass(type);
        }
        catch (Exception e) {
            throw new ReflectionError(this.unableToLoadClassMessage(type), e);
        }
    }

    private String unableToLoadClassMessage(Class<?> asType) {
        StringBuilder msg = new StringBuilder();
        msg.append("Unable to load class ").append(Strings.quote((String)this.name));
        if (asType != null) {
            msg.append(" as ").append(asType.getName());
        }
        msg.append(" using class loader ").append(this.classLoader);
        return msg.toString();
    }

    private Class<?> loadType() throws ClassNotFoundException {
        return this.classLoader.loadClass(this.name);
    }
}

